/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.util;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeMesa;
import rtg.api.RTGAPI;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;

public final class PlateauUtil {
    private static final HashMap<IRealisticBiome, List<IBlockState>> BIOME_PLATEAU_BANDS = Maps.newHashMap();
    private static final IBlockState DEFAULT_PLATEAU_BLOCK = Blocks.field_150405_ch.func_176223_P();
    private static final Collection<Biome> PLATEAU_BIOMES = Collections.unmodifiableCollection(Arrays.asList(Biomes.field_150589_Z, Biomes.field_185437_ai, Biomes.field_150607_aa, Biomes.field_185438_aj, Biomes.field_150608_ab, Biomes.field_185439_ak, Biomes.field_150587_Y, Biomes.field_185436_ah));
    private static final Collection<String> MESA_PLATEAU_BLOCKS = Collections.unmodifiableCollection(Arrays.asList("minecraft:stained_hardened_clay[color=yellow]", "minecraft:stained_hardened_clay[color=yellow]", "minecraft:stained_hardened_clay[color=yellow]", "minecraft:hardened_clay", "minecraft:hardened_clay", "minecraft:stained_hardened_clay[color=orange]", "minecraft:stained_hardened_clay[color=red]", "minecraft:stained_hardened_clay[color=red]", "minecraft:hardened_clay", "minecraft:stained_hardened_clay[color=silver]", "minecraft:stained_hardened_clay[color=white]", "minecraft:hardened_clay", "minecraft:hardened_clay", "minecraft:hardened_clay", "minecraft:stained_hardened_clay[color=orange]", "minecraft:hardened_clay", "minecraft:hardened_clay", "minecraft:hardened_clay", "minecraft:stained_hardened_clay[color=orange]", "minecraft:stained_hardened_clay[color=silver]", "minecraft:stained_hardened_clay[color=white]", "minecraft:stained_hardened_clay[color=brown]", "minecraft:stained_hardened_clay[color=brown]", "minecraft:stained_hardened_clay[color=brown]", "minecraft:hardened_clay", "minecraft:stained_hardened_clay[color=orange]", "minecraft:hardened_clay", "minecraft:stained_hardened_clay[color=orange]", "minecraft:hardened_clay", "minecraft:stained_hardened_clay[color=orange]", "minecraft:hardened_clay", "minecraft:hardened_clay", "minecraft:hardened_clay"));
    private static final Collection<String> SAVANNA_PLATEAU_BLOCKS = Collections.unmodifiableCollection(Arrays.asList("minecraft:stained_hardened_clay[color=white]", "minecraft:stained_hardened_clay[color=white]", "minecraft:stained_hardened_clay[color=white]", "minecraft:stained_hardened_clay[color=white]", "minecraft:stained_hardened_clay[color=silver]", "minecraft:stained_hardened_clay[color=silver]", "minecraft:stained_hardened_clay[color=brown]", "minecraft:stained_hardened_clay[color=brown]", "minecraft:stained_hardened_clay[color=silver]", "minecraft:stained_hardened_clay[color=white]", "minecraft:stained_hardened_clay[color=silver]", "minecraft:stained_hardened_clay[color=brown]", "minecraft:stained_hardened_clay[color=brown]", "minecraft:stained_hardened_clay[color=silver]", "minecraft:stained_hardened_clay[color=brown]", "minecraft:stained_hardened_clay[color=silver]", "minecraft:stained_hardened_clay[color=white]", "minecraft:stained_hardened_clay[color=white]", "minecraft:stained_hardened_clay[color=silver]", "minecraft:stained_hardened_clay[color=brown]", "minecraft:stained_hardened_clay[color=brown]"));

    private PlateauUtil() {
    }

    public static String[] getMesaPlateauBlocks() {
        return MESA_PLATEAU_BLOCKS.toArray(new String[0]);
    }

    public static String[] getSavannaPlateauBlocks() {
        return SAVANNA_PLATEAU_BLOCKS.toArray(new String[0]);
    }

    private static Collection<String> getConfigBlocks(IRealisticBiome rtgBiome) {
        BiomeConfig config = rtgBiome.getConfig();
        return config.hasProperty(config.PLATEAU_GRADIENT_BLOCK_LIST) && ((String[])config.PLATEAU_GRADIENT_BLOCK_LIST.getValues()).length > 0 ? config.PLATEAU_GRADIENT_BLOCK_LIST.getAsCollection() : (rtgBiome.baseBiome() instanceof BiomeMesa ? MESA_PLATEAU_BLOCKS : SAVANNA_PLATEAU_BLOCKS);
    }

    public static void init() {
        PLATEAU_BIOMES.stream().map(RTGAPI.RTG_BIOMES::get).filter(Objects::nonNull).forEach(rtgBiome -> {
            Collection<String> blocks = PlateauUtil.getConfigBlocks(rtgBiome);
            List bands = blocks.stream().map(BlockUtil::getBlockStateFromCfgString).filter(Objects::nonNull).collect(Collectors.toList());
            if (bands.isEmpty()) {
                bands.add(DEFAULT_PLATEAU_BLOCK);
            }
            BIOME_PLATEAU_BANDS.put((IRealisticBiome)rtgBiome, bands);
        });
    }

    public static IBlockState getPlateauBand(RTGWorld rtgWorld, IRealisticBiome rBiome, int x, int y, int z) {
        return PlateauUtil.getBand(rBiome, y);
    }

    public static float stepIncrease(float simplexVal, float start, float finish, float height) {
        return simplexVal <= start ? 0.0f : (simplexVal >= finish ? height : (simplexVal - start) / (finish - start) * height);
    }

    private static IBlockState getBand(IRealisticBiome rBiome, int index) {
        List<IBlockState> bands = BIOME_PLATEAU_BANDS.get(rBiome);
        return bands != null ? bands.get(index % bands.size()) : DEFAULT_PLATEAU_BLOCK;
    }
}

