/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.biome;

import java.util.Collection;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.RTGConfig;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.deco.collection.DecoCollectionBase;
import rtg.api.world.deco.collection.DecoCollectionDesertRiver;
import rtg.api.world.gen.feature.tree.rtg.TreeRTG;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public interface IRealisticBiome {
    public Biome baseBiome();

    public ResourceLocation baseBiomeResLoc();

    public int baseBiomeId();

    public RealisticBiomeBase.RiverType getRiverType();

    public RealisticBiomeBase.BeachType getBeachType();

    public IRealisticBiome getRiverBiome();

    public IRealisticBiome getBeachBiome();

    public Biome preferredBeach();

    public BiomeConfig getConfig();

    public TerrainBase terrain();

    public SurfaceBase surface();

    public void rReplace(ChunkPrimer var1, BlockPos var2, int var3, int var4, int var5, RTGWorld var6, float[] var7, float var8, Biome[] var9);

    public void rReplace(ChunkPrimer var1, int var2, int var3, int var4, int var5, int var6, RTGWorld var7, float[] var8, float var9, Biome[] var10);

    public float rNoise(RTGWorld var1, int var2, int var3, float var4, float var5);

    public double waterLakeMult();

    public double lavaLakeMult();

    public float lakePressure(RTGWorld var1, int var2, int var3, float var4, float var5, float var6, float var7, float var8);

    public void initDecos();

    public Collection<DecoBase> getDecos();

    @Deprecated
    public Collection<TreeRTG> getTrees();

    default public void addDeco(DecoBase deco, boolean allowed) {
        if (allowed) {
            Collection<DecoBase> decos = this.getDecos();
            if (!deco.properlyDefined()) {
                throw new RuntimeException(deco.toString());
            }
            decos.add(deco);
        }
    }

    default public void overrideDecorations() {
    }

    default public void addDeco(DecoBase deco) {
        if (!deco.properlyDefined()) {
            throw new RuntimeException(deco.toString());
        }
        this.addDeco(deco, true);
    }

    @Deprecated
    default public void addDecoCollection(DecoCollectionBase decoCollection) {
        int i;
        if (decoCollection instanceof DecoCollectionDesertRiver && !RTGConfig.lushRiverbanksInDesert()) {
            return;
        }
        if (decoCollection.decos.size() > 0) {
            for (i = 0; i < decoCollection.decos.size(); ++i) {
                this.addDeco(decoCollection.decos.get(i));
            }
        }
        if (decoCollection.rtgTrees.size() > 0) {
            for (i = 0; i < decoCollection.rtgTrees.size(); ++i) {
                this.addTree(decoCollection.rtgTrees.get(i));
            }
        }
    }

    @Deprecated
    default public void addTree(TreeRTG tree, boolean allowed) {
        if (allowed) {
            tree.setSaplingBlock(BlockUtil.getSaplingFromLeaves(tree.getLeavesBlock(), Blocks.field_150345_g.func_176223_P()));
            try {
                IBlockState leaves = tree.getLeavesBlock().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
                tree.setLeavesBlock(leaves);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getTrees().add(tree);
        }
    }

    @Deprecated
    default public void addTree(TreeRTG tree) {
        this.addTree(tree, true);
    }

    default public void rDecorate(RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        this.getDecos().stream().filter(deco -> deco.preGenerate(river)).forEach(deco -> deco.generate(this, rtgWorld, rand, chunkPos, river, hasVillage));
        if (this.overridesHardcoded()) {
            this.baseBiome().field_76760_I.func_180292_a(rtgWorld.world(), rand, this.baseBiome(), new BlockPos(chunkPos.field_77276_a * 16, 0, chunkPos.field_77275_b * 16));
        } else {
            this.baseBiome().func_180624_a(rtgWorld.world(), rand, new BlockPos(chunkPos.field_77276_a * 16, 0, chunkPos.field_77275_b * 16));
        }
    }

    default public boolean overridesHardcoded() {
        return false;
    }

    public TerrainBase initTerrain();

    public SurfaceBase initSurface();

    public void initConfig();
}

