/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;

public class DecoWorldGen
extends DecoBase {
    private WorldGenerator worldgen;
    private DecorateBiomeEvent.Decorate.EventType eventtype;
    private int loops;
    private int chance;
    private int minY;
    private int maxY;

    public DecoWorldGen(WorldGenerator worldgen) {
        this.setWorldGen(worldgen);
        this.setEventType(DecorateBiomeEvent.Decorate.EventType.CUSTOM);
        this.setLoops(1);
        this.setChance(1);
        this.setMinY(1);
        this.setMaxY(255);
        this.addDecoTypes(DecoBase.DecoType.WORLDGEN);
    }

    public DecoWorldGen(WorldGenerator worldgen, DecorateBiomeEvent.Decorate.EventType eventtype) {
        this(worldgen);
        this.setEventType(eventtype);
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        for (int i = 0; i <= this.loops; ++i) {
            BlockPos pos = DecoWorldGen.getOffsetPos(chunkPos).func_177982_a(rand.nextInt(16), 0, rand.nextInt(16));
            int y = rtgWorld.world().func_175645_m(pos).func_177956_o();
            if (y < this.minY || y > this.maxY || rand.nextInt(this.chance) != 0 || !TerrainGen.decorate((World)rtgWorld.world(), (Random)rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)this.eventtype)) continue;
            this.worldgen.func_180709_b(rtgWorld.world(), rand, pos.func_177981_b(y));
        }
    }

    public WorldGenerator getWorldGen() {
        return this.worldgen;
    }

    public DecoWorldGen setWorldGen(WorldGenerator worldgen) {
        this.worldgen = worldgen;
        return this;
    }

    public DecorateBiomeEvent.Decorate.EventType getEventType() {
        return this.eventtype;
    }

    public DecoWorldGen setEventType(DecorateBiomeEvent.Decorate.EventType eventtype) {
        this.eventtype = eventtype;
        return this;
    }

    public int getLoops() {
        return this.loops;
    }

    public DecoWorldGen setLoops(int loops) {
        this.loops = loops;
        return this;
    }

    public int getChance() {
        return this.chance;
    }

    public DecoWorldGen setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public int getMinY() {
        return this.minY;
    }

    public DecoWorldGen setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DecoWorldGen setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }
}

