/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.abyssalcraft;

import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.abyssalcraft.RealisticBiomeACBase;
import rtg.world.biome.realistic.abyssalcraft.SurfaceACBase;

public class RealisticBiomeACDarklands
extends RealisticBiomeACBase {
    public static Biome biome = ACBiomes.darklands;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeACDarklands() {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainACDarklands();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceACDarklands(this.getConfig(), RealisticBiomeACDarklands.biome.field_76752_A, RealisticBiomeACDarklands.biome.field_76753_B, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, RealisticBiomeACDarklands.biome.field_76752_A, 0.15f);
    }

    @Override
    public void initDecos() {
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE);
        decoFallenTree.setLogConditionChance(8);
        decoFallenTree.setLogBlock(ACBlocks.darklands_oak_wood.func_176223_P());
        decoFallenTree.setLeavesBlock(ACBlocks.darklands_oak_leaves.func_176223_P());
        decoFallenTree.setMinSize(2);
        decoFallenTree.setMaxSize(3);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
        DecoShrub decoShrubCustom = new DecoShrub();
        decoShrubCustom.setLogBlock(ACBlocks.darklands_oak_wood.func_176223_P());
        decoShrubCustom.setLeavesBlock(ACBlocks.darklands_oak_leaves.func_176223_P());
        decoShrubCustom.setMaxY(110);
        decoShrubCustom.setNotEqualsZeroChance(3);
        decoShrubCustom.setLoopMultiplier(2.0f);
        this.addDeco(decoShrubCustom);
    }

    public static class SurfaceACDarklands
    extends SurfaceACBase {
        private float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;
        private IBlockState mixBlock;
        private float mixHeight;

        public SurfaceACDarklands(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff, IBlockState mix, float mixSize) {
            super(config, top, fill);
            this.min = minCliff;
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mix);
            this.mixHeight = mixSize;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            boolean m = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > this.mixHeight) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        m = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainACDarklands
    extends TerrainBase {
        private float hillStrength = 40.0f;

        public TerrainACDarklands() {
            this(72.0f, 40.0f);
        }

        public TerrainACDarklands(float bh, float hs) {
            this.base = bh;
            this.hillStrength = hs;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainACDarklands.terrainHighland(x, y, rtgWorld, river, 10.0f, 68.0f, this.hillStrength, this.base - 62.0f);
        }
    }
}

