/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.traverse;

import net.minecraft.world.biome.Biome;
import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexData2D;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.traverse.RealisticBiomeTRAVBase;

public class RealisticBiomeTRAVMountainousDesert
extends RealisticBiomeTRAVBase {
    public RealisticBiomeTRAVMountainousDesert(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainHLGreyMountains(230.0f, 100.0f, 68.0f);
    }

    public static class TerrainHLGreyMountains
    extends TerrainBase {
        private float width;
        private float strength;
        private float terrainHeight;
        private int wavelength = 39;
        private ISimplexData2D jitter = SimplexData2D.newDisk();
        private double amplitude = 12.0;

        public TerrainHLGreyMountains(float mountainWidth, float mountainStrength, float height) {
            this.width = mountainWidth;
            this.strength = mountainStrength;
            this.terrainHeight = height;
            this.terrainHeight = 30.0f;
            this.width = 120.0f;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            simplex.multiEval2D((float)x / (float)this.wavelength, (float)y / (float)this.wavelength, this.jitter);
            float pX = (float)((double)x + this.jitter.getDeltaX() * this.amplitude);
            float pY = (float)((double)y + this.jitter.getDeltaY() * this.amplitude);
            float h = simplex.noise2f(pX / 19.0f, pY / 19.0f);
            h = h * h * 2.0f;
            float h2 = simplex.noise2f(pX / 13.0f, pY / 13.0f);
            h2 = h2 * h2 * 1.3f;
            h = Math.max(h, h2);
            h += h2;
            float h3 = simplex.noise2f(pX / 53.0f, pY / 53.0f);
            h3 = h3 * h3 * 5.0f;
            float m = TerrainHLGreyMountains.unsignedPower(simplex.noise2f(pX / this.width, pY / this.width), 1.4f) * this.strength * river;
            float m2 = TerrainHLGreyMountains.unsignedPower(simplex.noise2f(pY / (this.width * 1.5f), pX / (this.width * 1.5f)), 1.4f) * this.strength * river;
            m = Math.max(m, m2);
            h = m > 10.0f ? h * m / 10.0f : (h += h3);
            m = TerrainHLGreyMountains.above(m, -50.0f);
            return this.terrainHeight + h + m;
        }
    }
}

