/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.traverse;

import net.minecraft.world.biome.Biome;
import rtg.api.util.PlateauUtil;
import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexData2D;
import rtg.api.world.RTGWorld;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.VoronoiPlateauEffect;
import rtg.world.biome.realistic.traverse.RealisticBiomeTRAVBase;

public class RealisticBiomeTRAVRockyPlateau
extends RealisticBiomeTRAVBase {
    public RealisticBiomeTRAVRockyPlateau(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainRTGMesaPlateau(67.0f);
    }

    public static class TerrainRTGMesaPlateau
    extends TerrainBase {
        private static final float stepStart = 0.25f;
        private static final float stepFinish = 0.4f;
        private static final float stepHeight = 32.0f;
        final VoronoiPlateauEffect plateau = new VoronoiPlateauEffect();
        final int groundNoise;
        private float jitterWavelength = 30.0f;
        private float jitterAmplitude = 10.0f;
        private float bumpinessMultiplier = 0.05f;
        private float bumpinessWavelength = 10.0f;

        public TerrainRTGMesaPlateau(float base) {
            this.plateau.pointWavelength = 200.0f;
            this.base = base;
            this.groundNoise = 4;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int passedX, int passedY, float border, float river) {
            float f;
            float f2;
            ISimplexData2D jitterData = SimplexData2D.newDisk();
            rtgWorld.simplexInstance(1).multiEval2D((float)passedX / this.jitterWavelength, (float)passedY / this.jitterWavelength, jitterData);
            float x = (float)((double)passedX + jitterData.getDeltaX() * (double)this.jitterAmplitude);
            float y = (float)((double)passedY + jitterData.getDeltaY() * (double)this.jitterAmplitude);
            float bordercap = border * 3.5f - 2.5f;
            bordercap = f2 > 1.0f ? 1.0f : bordercap;
            float rivercap = 3.0f * river;
            rivercap = f > 1.0f ? 1.0f : rivercap;
            float bumpiness = rtgWorld.simplexInstance(2).noise2f(x / this.bumpinessWavelength, y / this.bumpinessWavelength) * this.bumpinessMultiplier;
            float simplex = this.plateau.added(rtgWorld, x, y) * bordercap * rivercap + bumpiness;
            float added = PlateauUtil.stepIncrease(simplex, 0.25f, 0.4f, 32.0f) / border;
            return TerrainRTGMesaPlateau.riverized(this.base + TerrainBase.groundNoise(x, y, (float)this.groundNoise, rtgWorld), river) + added;
        }
    }
}

