/*
 * Decompiled with CFR 0.152.
 */
package lumien.chunkanimator.asm;

import lumien.chunkanimator.asm.MCPNames;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    Logger logger = LogManager.getLogger((String)"ChunkAnimatorCore");
    final String asmHandler = "lumien/chunkanimator/handler/AsmHandler";

    public ClassTransformer() {
        this.logger.log(Level.DEBUG, "Starting Class Transformation");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.renderer.ChunkRenderContainer")) {
            return this.patchChunkRenderContainer(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.chunk.RenderChunk")) {
            return this.patchRenderChunk(basicClass);
        }
        return basicClass;
    }

    private byte[] patchRenderChunk(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found RenderChunk Class: " + classNode.name);
        MethodNode setOrigin = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_189562_a"))) continue;
            setOrigin = mn;
            break;
        }
        if (setOrigin != null) {
            this.logger.log(Level.DEBUG, "- Found setOrigin");
            for (int i = 0; i < setOrigin.instructions.size(); ++i) {
                AbstractInsnNode ain = setOrigin.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(MCPNames.method("func_178585_h"))) continue;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 1));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 2));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 3));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/chunkanimator/handler/AsmHandler", "setOrigin", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;III)V", false));
                setOrigin.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                i += 5;
            }
            this.logger.log(Level.DEBUG, "- Patched setOrigin");
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchChunkRenderContainer(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found ChunkRenderContainer Class: " + classNode.name);
        MethodNode preRenderChunk = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_178003_a"))) continue;
            preRenderChunk = mn;
            break;
        }
        if (preRenderChunk != null) {
            this.logger.log(Level.DEBUG, "- Found preRenderChunk");
            for (int i = 0; i < preRenderChunk.instructions.size(); ++i) {
                AbstractInsnNode ain = preRenderChunk.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(MCPNames.method("func_179109_b"))) continue;
                this.logger.log(Level.DEBUG, "- Patched preRenderChunk");
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/chunkanimator/handler/AsmHandler", "preRenderChunk", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;)V", false));
                preRenderChunk.instructions.insert((AbstractInsnNode)min, toInsert);
                break;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchDummyClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found Dummy Class: " + classNode.name);
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

