/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zathrox.explorercraft.init.BlockReg;
import zathrox.explorercraft.init.ItemReg;

public class BlockRiceTop
extends BlockCrops {
    public static final AxisAlignedBB[] CENTRE_SIXTEEN = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    private static final float DEATH_CHANCE = 0.5f;
    private static final float GROWTH_CHANCE = 0.3f;

    public BlockRiceTop() {
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.checkStay(world, state, pos)) {
            return;
        }
        int oldAge = (Integer)state.func_177229_b((IProperty)AGE);
        int newAge = Math.min(oldAge + 1, 7);
        if (rand.nextFloat() <= 0.3f) {
            IBlockState newState = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(newAge));
            world.func_175656_a(pos, newState);
        }
    }

    public boolean checkStay(World world, IBlockState state, BlockPos pos) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != BlockReg.RICE_BASE) {
            world.func_175698_g(pos);
            if (!world.field_72995_K) {
                this.func_176226_b(world, pos, state, 0);
            }
            return false;
        }
        return true;
    }

    private boolean canGrow(World world, BlockPos pos) {
        return world.func_175642_b(EnumSkyBlock.SKY, pos) >= 8;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos unused) {
        this.checkStay(world, state, pos);
    }

    protected Item func_149866_i() {
        return ItemReg.RICE_STRAW;
    }

    protected Item func_149865_P() {
        return ItemReg.RICE;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 7) {
            return 2 + random.nextInt(2 + fortune + 1);
        }
        return 1;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CENTRE_SIXTEEN[(Integer)state.func_177229_b((IProperty)AGE)];
    }
}

