/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.blocks.trees;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.event.terraingen.TerrainGen;
import zathrox.explorercraft.init.BlockReg;
import zathrox.explorercraft.world.trees.WorldGenAshTree;
import zathrox.explorercraft.world.trees.WorldGenBambooTree;
import zathrox.explorercraft.world.trees.WorldGenJapaneseMaple;
import zathrox.explorercraft.world.trees.WorldGenKwanzanCherry;

public class BlockExplorerSapling
extends BlockBush
implements IGrowable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    private static String type;

    public BlockExplorerSapling() {
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= (Integer)state.func_177229_b((IProperty)STAGE) << 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, rand, pos, state);
        }
    }

    public void generateTree(World world, Random rand, BlockPos pos, IBlockState state) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        Object gen = rand.nextInt(10) == 0 ? new WorldGenBigTree(false) : new WorldGenTrees(false);
        boolean flag = false;
        int i = 0;
        int j = 0;
        if (this.field_176227_L.func_177622_c() == BlockReg.BAMBOO_SAPLING) {
            gen = new WorldGenBambooTree(false);
            System.out.println("Bamboo Sapling Grown");
            flag = true;
        } else if (this.field_176227_L.func_177622_c() == BlockReg.MAPLE_SAPLING) {
            gen = new WorldGenJapaneseMaple(false);
            System.out.println("Maple Sapling Grown");
            flag = true;
        } else if (this.field_176227_L.func_177622_c() == BlockReg.ASH_SAPLING) {
            for (j = 0; j >= -1; --j) {
                if (!this.isTwoByTwoOfType(world, pos, i, j)) continue;
                gen = new WorldGenAshTree(false);
                System.out.println("Ash Sapling Grown");
                flag = true;
                break;
            }
            if (!flag) {
                return;
            }
        } else if (this.field_176227_L.func_177622_c() == BlockReg.CHERRY_SAPLING) {
            gen = new WorldGenKwanzanCherry(false);
            System.out.println("Cherry Sapling Grown");
        }
        IBlockState iblockstate = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            world.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate, 4);
            world.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate, 4);
            world.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate, 4);
            world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate, 4);
        } else {
            world.func_180501_a(pos, iblockstate, 4);
        }
        if (!gen.func_180709_b(world, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                world.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate, 4);
                world.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate, 4);
            } else {
                world.func_180501_a(pos, iblockstate, 4);
            }
        }
    }

    private boolean isTwoByTwoOfType(World worldIn, BlockPos pos, int p_181624_3_, int p_181624_4_) {
        return this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_, 0, p_181624_4_)) && this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_ + 1, 0, p_181624_4_)) && this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_, 0, p_181624_4_ + 1)) && this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_ + 1, 0, p_181624_4_ + 1));
    }

    public boolean isTypeAt(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        return iblockstate.func_177230_c() == this;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }
}

