/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zathrox.explorercraft.entity.ai.EntityAIWizardLookAtTradePlayer;
import zathrox.explorercraft.entity.ai.EntityAIWizardTradePlayer;
import zathrox.explorercraft.init.BlockReg;
import zathrox.explorercraft.init.ItemReg;

public class EntityWizard
extends EntityMob
implements IMerchant,
INpc {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityWizard.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityGhast.class, (DataSerializer)DataSerializers.field_187198_h);
    public int lightTime = 0;
    public int timeToHeal = 0;
    public int spellType = 0;
    public int spellTime = 0;
    @Nullable
    private EntityPlayer buyingPlayer;
    private int timeUntilReset;
    private UUID lastBuyingPlayer;
    @Nullable
    private MerchantRecipeList buyingList;

    public EntityWizard(World world) {
        super(world);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWizardTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWizardLookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityVillager.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.field_70163_u) + 1;
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < 10.0f) {
                ++this.spellTime;
                System.out.println("Spell Timer: " + this.spellTime);
                if (this.spellTime > 31 && this.func_110143_aJ() <= 9.0f) {
                    float health = this.func_110143_aJ();
                    this.func_70606_j(health + 5.0f);
                    System.out.println("Healed");
                    System.out.println("Current HP: " + this.func_110143_aJ());
                    this.spellTime = 1;
                    for (int i = 0; i < 10; ++i) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
                    }
                }
                this.setSpellType(1);
            }
        }
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        this.lightTime = 0;
        this.spellTime = 0;
        this.setSpellType(0);
        super.func_70645_a(par1DamageSource);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.isAttacking()) {
            double d0 = 0.7;
            double d1 = 0.5;
            double d2 = 0.2;
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v + (double)f2 * 0.6, d0, d1, d2, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t - (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v - (double)f2 * 0.6, d0, d1, d2, new int[0]);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent getLivingSound() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public void setSpellType(int i) {
        this.spellType = i;
    }

    public int getSpellType() {
        return this.spellType;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("explorercraft", "entities/wizard");
    }

    public float func_70047_e() {
        return 1.74f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void setSwingingArms(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.buyingPlayer = player;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        MerchantRecipeList trades = new MerchantRecipeList();
        if (trades == null || trades.isEmpty()) {
            this.func_70930_a(trades);
        }
        return trades;
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
        recipeList.add((Object)new MerchantRecipe(new ItemStack(BlockReg.DRAGON_HEART), new ItemStack(BlockReg.SLATE_CHISELED, 8), new ItemStack(BlockReg.SLATE_WELSH, 64)));
        recipeList.add((Object)new MerchantRecipe(new ItemStack(BlockReg.DRAGON_HEART), new ItemStack(Blocks.field_150325_L, 64, 7), new ItemStack(ItemReg.WIZARD_HAT), 0, 1));
        recipeList.add((Object)new MerchantRecipe(new ItemStack(BlockReg.DRAGON_HEART), new ItemStack(BlockReg.ASH_LOG, 64), new ItemStack(ItemReg.WIZARD_STAFF), 0, 1));
        recipeList.add((Object)new MerchantRecipe(new ItemStack(BlockReg.DRAGON_HEART), new ItemStack(Items.field_151042_j, 64), new ItemStack(ItemReg.WELSH_SHEILD), 0, 1));
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.func_110124_au() : null;
            i += 5;
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70932_a_(player);
            player.func_180472_a((IMerchant)this);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private final EntityWizard wizard;
        private int attackStep;
        private int attackTime;

        public AIFireballAttack(EntityWizard wizardIn) {
            this.wizard = wizardIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.wizard.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.wizard.setAttacking(false);
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.wizard.func_70638_az();
            double d0 = this.wizard.func_70068_e((Entity)entitylivingbase);
            if (d0 < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.wizard.func_70652_k((Entity)entitylivingbase);
                }
                this.wizard.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 3.0);
            } else if (d0 < this.getFollowDistance() * this.getFollowDistance()) {
                double d1 = entitylivingbase.field_70165_t - this.wizard.field_70165_t;
                double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (this.wizard.field_70163_u + (double)(this.wizard.field_70131_O / 2.0f));
                double d3 = entitylivingbase.field_70161_v - this.wizard.field_70161_v;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                    } else if (this.attackStep <= 10) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                    }
                    if (this.attackStep > 1) {
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                        this.wizard.field_70170_p.func_180498_a((EntityPlayer)null, 1018, new BlockPos((int)this.wizard.field_70165_t, (int)this.wizard.field_70163_u, (int)this.wizard.field_70161_v), 0);
                        EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.wizard.field_70170_p, (EntityLivingBase)this.wizard, d1, d2, d3);
                        entitysmallfireball.field_70163_u = this.wizard.field_70163_u + (double)(this.wizard.field_70131_O / 2.0f) + 0.5;
                        this.wizard.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                    }
                }
                this.wizard.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
            } else {
                this.wizard.func_70661_as().func_75499_g();
                this.wizard.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            }
            this.wizard.setAttacking(this.attackStep > 1);
            super.func_75246_d();
        }

        private double getFollowDistance() {
            IAttributeInstance iattributeinstance = this.wizard.func_110148_a(SharedMonsterAttributes.field_111265_b);
            return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
        }
    }
}

