/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.events;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.crash.CrashReport;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zathrox.explorercraft.blocks.AmethystOre;
import zathrox.explorercraft.blocks.BlockBambooLog;
import zathrox.explorercraft.blocks.BlockBasalt;
import zathrox.explorercraft.blocks.BlockDaffodil;
import zathrox.explorercraft.blocks.BlockDragonHeart;
import zathrox.explorercraft.blocks.BlockLeek;
import zathrox.explorercraft.blocks.BlockLeekWild;
import zathrox.explorercraft.blocks.BlockMarble;
import zathrox.explorercraft.blocks.BlockNoctiluca;
import zathrox.explorercraft.blocks.BlockOreBlock;
import zathrox.explorercraft.blocks.BlockRiceBase;
import zathrox.explorercraft.blocks.BlockRiceTop;
import zathrox.explorercraft.blocks.BlockSlate;
import zathrox.explorercraft.blocks.BlockTatami;
import zathrox.explorercraft.blocks.BlockTatamiHalf;
import zathrox.explorercraft.blocks.BlockWaterPlantBase;
import zathrox.explorercraft.blocks.JadeOre;
import zathrox.explorercraft.blocks.RubyOre;
import zathrox.explorercraft.blocks.decor.BlockExplorerDoor;
import zathrox.explorercraft.blocks.decor.BlockExplorerFence;
import zathrox.explorercraft.blocks.decor.BlockExplorerFenceGate;
import zathrox.explorercraft.blocks.decor.BlockExplorerStairs;
import zathrox.explorercraft.blocks.decor.BlockExplorerWall;
import zathrox.explorercraft.blocks.decor.BlockPillar;
import zathrox.explorercraft.blocks.slabs.BlockAshSlab;
import zathrox.explorercraft.blocks.slabs.BlockBambooSlab;
import zathrox.explorercraft.blocks.slabs.BlockBasaltSlab;
import zathrox.explorercraft.blocks.slabs.BlockCherrySlab;
import zathrox.explorercraft.blocks.slabs.BlockMapleSlab;
import zathrox.explorercraft.blocks.slabs.BlockMarbleSlab;
import zathrox.explorercraft.blocks.slabs.BlockSlateSlab;
import zathrox.explorercraft.blocks.trees.BlockExplorerLeaves;
import zathrox.explorercraft.blocks.trees.BlockExplorerLog;
import zathrox.explorercraft.blocks.trees.BlockExplorerPlanks;
import zathrox.explorercraft.blocks.trees.BlockExplorerSapling;
import zathrox.explorercraft.entity.EntityEnderghast;
import zathrox.explorercraft.entity.EntityEnderreeper;
import zathrox.explorercraft.entity.EntityWizard;
import zathrox.explorercraft.init.BlockReg;
import zathrox.explorercraft.init.MaterialsRegistry;
import zathrox.explorercraft.items.Amethyst;
import zathrox.explorercraft.items.ItemBuilder;
import zathrox.explorercraft.items.ItemCawl;
import zathrox.explorercraft.items.ItemNoctiluca;
import zathrox.explorercraft.items.ItemRice;
import zathrox.explorercraft.items.ItemTatami;
import zathrox.explorercraft.items.ItemTatamiHalf;
import zathrox.explorercraft.items.ItemWelshShield;
import zathrox.explorercraft.items.ItemWizardStaff;
import zathrox.explorercraft.items.Jade;
import zathrox.explorercraft.items.Ruby;
import zathrox.explorercraft.items.armor.ItemAmethystHorseArmor;
import zathrox.explorercraft.items.armor.ItemExplorerArmor;
import zathrox.explorercraft.items.armor.ItemJadeHorseArmor;
import zathrox.explorercraft.items.armor.ItemRubyHorseArmor;
import zathrox.explorercraft.items.tools.ToolAxe;
import zathrox.explorercraft.items.tools.ToolHoe;
import zathrox.explorercraft.items.tools.ToolPickaxe;
import zathrox.explorercraft.items.tools.ToolShovel;
import zathrox.explorercraft.items.tools.ToolSword;
import zathrox.explorercraft.tab.ExplorercraftTab;
import zathrox.explorercraft.util.RarityHandler;

@Mod.EventBusSubscriber(modid="explorercraft")
public final class EventHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"explorercraft Event Subscriber");
    private static int entityId = 0;

    @SubscribeEvent
    public static void onRegisterBlocksEvent(@Nonnull RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{EventHandler.setup(new RubyOre(), "ruby_ore"), EventHandler.setup(new AmethystOre(), "amethyst_ore"), EventHandler.setup(new JadeOre(), "jade_ore"), EventHandler.setup(new BlockOreBlock(), "ruby_block"), EventHandler.setup(new BlockOreBlock(), "amethyst_block"), EventHandler.setup(new BlockOreBlock(), "jade_block"), EventHandler.setup(new BlockBasalt(), "basalt"), EventHandler.setup(new BlockBasalt(), "basalt_cobblestone"), EventHandler.setup(new BlockBasalt(), "basalt_polished"), EventHandler.setup(new BlockBasalt(), "basalt_bricks"), EventHandler.setup(new BlockBasalt(), "basalt_mossy"), EventHandler.setup(new BlockBasalt(), "basalt_cracked"), EventHandler.setup(new BlockBasalt(), "basalt_chiseled"), EventHandler.setup(new BlockPillar(), "basalt_pillar"), EventHandler.setup(new BlockMarble(), "marble"), EventHandler.setup(new BlockMarble(), "marble_polished"), EventHandler.setup(new BlockMarble(), "marble_bricks"), EventHandler.setup(new BlockMarble(), "marble_mossy"), EventHandler.setup(new BlockMarble(), "marble_cracked"), EventHandler.setup(new BlockMarble(), "marble_chiseled"), EventHandler.setup(new BlockPillar(), "marble_pillar"), EventHandler.setup(new BlockSlate(), "slate"), EventHandler.setup(new BlockSlate(), "slate_polished"), EventHandler.setup(new BlockSlate(), "slate_bricks"), EventHandler.setup(new BlockSlate(), "slate_mossy"), EventHandler.setup(new BlockSlate(), "slate_tile"), EventHandler.setup(new BlockSlate(), "slate_chiseled"), EventHandler.setup(new BlockSlate(), "slate_welsh"), EventHandler.setup(new BlockPillar(), "slate_pillar"), (Block)EventHandler.setup(new BlockExplorerLeaves(), "ash_leaves"), (Block)EventHandler.setup(new BlockExplorerLeaves(), "bamboo_leaves"), (Block)EventHandler.setup(new BlockExplorerLeaves(), "cherry_leaves"), (Block)EventHandler.setup(new BlockExplorerLeaves(), "maple_leaves"), (Block)EventHandler.setup(new BlockExplorerLog(), "ash_log"), EventHandler.setup(new BlockBambooLog(), "bamboo_log"), (Block)EventHandler.setup(new BlockExplorerLog(), "cherry_log"), (Block)EventHandler.setup(new BlockExplorerLog(), "maple_log"), EventHandler.setup(new BlockExplorerPlanks(), "ash_planks"), EventHandler.setup(new BlockExplorerPlanks(), "bamboo_planks"), EventHandler.setup(new BlockExplorerPlanks(), "bamboo_planks_vertical"), EventHandler.setup(new BlockExplorerPlanks(), "cherry_planks"), EventHandler.setup(new BlockExplorerPlanks(), "maple_planks"), (Block)EventHandler.setup(new BlockExplorerSapling(), "ash_sapling"), (Block)EventHandler.setup(new BlockExplorerSapling(), "bamboo_sapling"), (Block)EventHandler.setup(new BlockExplorerSapling(), "cherry_sapling"), (Block)EventHandler.setup(new BlockExplorerSapling(), "maple_sapling"), (Block)EventHandler.setup(new BlockBasaltSlab.Half(), "basalt_brick_slab"), (Block)EventHandler.setup(new BlockBasaltSlab.Double(), "basalt_brick_double_slab"), (Block)EventHandler.setup(new BlockMarbleSlab.Half(), "marble_brick_slab"), (Block)EventHandler.setup(new BlockMarbleSlab.Double(), "marble_brick_double_slab"), (Block)EventHandler.setup(new BlockSlateSlab.Half(), "slate_brick_slab"), (Block)EventHandler.setup(new BlockSlateSlab.Double(), "slate_brick_double_slab"), (Block)EventHandler.setup(new BlockBambooSlab.Half(), "bamboo_slab"), (Block)EventHandler.setup(new BlockBambooSlab.Double(), "bamboo_double_slab"), (Block)EventHandler.setup(new BlockCherrySlab.Half(), "cherry_slab"), (Block)EventHandler.setup(new BlockCherrySlab.Double(), "cherry_double_slab"), (Block)EventHandler.setup(new BlockMapleSlab.Half(), "maple_slab"), (Block)EventHandler.setup(new BlockMapleSlab.Double(), "maple_double_slab"), (Block)EventHandler.setup(new BlockAshSlab.Half(), "ash_slab"), (Block)EventHandler.setup(new BlockAshSlab.Double(), "ash_double_slab"), (Block)EventHandler.setup(new BlockExplorerFence(), "ash_fence"), (Block)EventHandler.setup(new BlockExplorerFence(), "bamboo_fence"), (Block)EventHandler.setup(new BlockExplorerFence(), "cherry_fence"), (Block)EventHandler.setup(new BlockExplorerFence(), "maple_fence"), (Block)EventHandler.setup(new BlockExplorerFenceGate(), "ash_fence_gate"), (Block)EventHandler.setup(new BlockExplorerFenceGate(), "bamboo_fence_gate"), (Block)EventHandler.setup(new BlockExplorerFenceGate(), "cherry_fence_gate"), (Block)EventHandler.setup(new BlockExplorerFenceGate(), "maple_fence_gate"), (Block)EventHandler.setup(new BlockExplorerDoor(), "ash_door"), (Block)EventHandler.setup(new BlockExplorerDoor(), "bamboo_door"), (Block)EventHandler.setup(new BlockExplorerDoor(), "cherry_door"), (Block)EventHandler.setup(new BlockExplorerDoor(), "maple_door"), EventHandler.setup(new BlockExplorerWall(), "basalt_brick_wall"), EventHandler.setup(new BlockExplorerWall(), "marble_brick_wall"), EventHandler.setup(new BlockExplorerWall(), "slate_brick_wall"), (Block)EventHandler.setup(new BlockTatami(), "tatami"), EventHandler.setup(new BlockTatamiHalf(), "tatami_half"), EventHandler.setup(new BlockRiceBase(), "rice_base"), (Block)EventHandler.setup(new BlockRiceTop(), "rice_top"), (Block)EventHandler.setup(new BlockLeek(), "leek_crop"), (Block)EventHandler.setup(new BlockLeekWild(), "leek_wild"), (Block)EventHandler.setup(new BlockDaffodil(), "daffodil"), (Block)EventHandler.setup(new BlockWaterPlantBase(), "water_grass"), (Block)EventHandler.setup(new BlockNoctiluca(), "noctiluca_plant"), EventHandler.setup(new BlockDragonHeart(), "dragon_heart")});
        LOGGER.debug("Registered blocks");
        LOGGER.debug("Registered tile entities");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerBlocksAfter(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Block basalt_brick = (Block)registry.getValue(new ResourceLocation("explorercraft", "basalt_bricks"));
        Block marble_brick = (Block)registry.getValue(new ResourceLocation("explorercraft", "marble_bricks"));
        Block slate_brick = (Block)registry.getValue(new ResourceLocation("explorercraft", "slate_bricks"));
        Block slate_tile = (Block)registry.getValue(new ResourceLocation("explorercraft", "slate_tile"));
        Block ash_planks = (Block)registry.getValue(new ResourceLocation("explorercraft", "ash_planks"));
        Block bamboo_planks = (Block)registry.getValue(new ResourceLocation("explorercraft", "bamboo_planks"));
        Block cherry_planks = (Block)registry.getValue(new ResourceLocation("explorercraft", "cherry_planks"));
        Block maple_planks = (Block)registry.getValue(new ResourceLocation("explorercraft", "maple_planks"));
        assert (basalt_brick != null);
        assert (marble_brick != null);
        assert (bamboo_planks != null);
        assert (cherry_planks != null);
        assert (maple_planks != null);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)EventHandler.setup(new BlockExplorerStairs(basalt_brick), "basalt_brick_stairs"), (Block)EventHandler.setup(new BlockExplorerStairs(marble_brick), "marble_brick_stairs"), (Block)EventHandler.setup(new BlockExplorerStairs(slate_brick), "slate_brick_stairs"), (Block)EventHandler.setup(new BlockExplorerStairs(slate_tile), "slate_tile_stairs"), (Block)EventHandler.setup(new BlockExplorerStairs(ash_planks), "ash_stairs"), (Block)EventHandler.setup(new BlockExplorerStairs(bamboo_planks), "bamboo_stairs"), (Block)EventHandler.setup(new BlockExplorerStairs(cherry_planks), "cherry_stairs"), (Block)EventHandler.setup(new BlockExplorerStairs(maple_planks), "maple_stairs")});
    }

    private static void registerTileEntity(@Nonnull Class<? extends TileEntity> clazz, @Nonnull String name) {
        try {
            GameRegistry.registerTileEntity(clazz, (ResourceLocation)new ResourceLocation("explorercraft", name));
        }
        catch (Exception exception) {
            CrashReport crashReport = new CrashReport("Error registering Tile Entity " + clazz.getSimpleName() + " with name " + name, (Throwable)exception);
            crashReport.func_85058_a("Registering Tile Entity");
            throw new ReportedException(crashReport);
        }
    }

    @SubscribeEvent
    public static void onRegisterItemsEvent(@Nonnull RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Item[]{EventHandler.setup(new Ruby(), "ruby"), EventHandler.setup(new Amethyst(), "amethyst"), EventHandler.setup(new Jade(), "jade"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.RUBY_ARMOR, EntityEquipmentSlot.HEAD), "ruby_helmet"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.RUBY_ARMOR, EntityEquipmentSlot.CHEST), "ruby_chestplate"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.RUBY_ARMOR, EntityEquipmentSlot.LEGS), "ruby_leggings"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.RUBY_ARMOR, EntityEquipmentSlot.FEET), "ruby_boots"), (Item)EventHandler.setup(new ToolAxe(MaterialsRegistry.RUBY_TOOLS, 8.0f, -3.0f), "ruby_axe"), (Item)EventHandler.setup(new ToolHoe(MaterialsRegistry.RUBY_TOOLS), "ruby_hoe"), (Item)EventHandler.setup(new ToolPickaxe(MaterialsRegistry.RUBY_TOOLS), "ruby_pickaxe"), (Item)EventHandler.setup(new ToolShovel(MaterialsRegistry.RUBY_TOOLS), "ruby_shovel"), (Item)EventHandler.setup(new ToolSword(MaterialsRegistry.RUBY_TOOLS), "ruby_sword"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.AMETHYST_ARMOR, EntityEquipmentSlot.HEAD), "amethyst_helmet"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.AMETHYST_ARMOR, EntityEquipmentSlot.CHEST), "amethyst_chestplate"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.AMETHYST_ARMOR, EntityEquipmentSlot.LEGS), "amethyst_leggings"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.AMETHYST_ARMOR, EntityEquipmentSlot.FEET), "amethyst_boots"), (Item)EventHandler.setup(new ToolAxe(MaterialsRegistry.AMETHYST_TOOLS, 8.0f, -3.0f), "amethyst_axe"), (Item)EventHandler.setup(new ToolHoe(MaterialsRegistry.AMETHYST_TOOLS), "amethyst_hoe"), (Item)EventHandler.setup(new ToolPickaxe(MaterialsRegistry.AMETHYST_TOOLS), "amethyst_pickaxe"), (Item)EventHandler.setup(new ToolShovel(MaterialsRegistry.AMETHYST_TOOLS), "amethyst_shovel"), (Item)EventHandler.setup(new ToolSword(MaterialsRegistry.AMETHYST_TOOLS), "amethyst_sword"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.JADE_ARMOR, EntityEquipmentSlot.HEAD), "jade_helmet"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.JADE_ARMOR, EntityEquipmentSlot.CHEST), "jade_chestplate"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.JADE_ARMOR, EntityEquipmentSlot.LEGS), "jade_leggings"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.JADE_ARMOR, EntityEquipmentSlot.FEET), "jade_boots"), (Item)EventHandler.setup(new ToolAxe(MaterialsRegistry.JADE_TOOLS, 8.0f, -2.9f), "jade_axe"), (Item)EventHandler.setup(new ToolHoe(MaterialsRegistry.JADE_TOOLS), "jade_hoe"), (Item)EventHandler.setup(new ToolPickaxe(MaterialsRegistry.JADE_TOOLS), "jade_pickaxe"), (Item)EventHandler.setup(new ToolShovel(MaterialsRegistry.JADE_TOOLS), "jade_shovel"), (Item)EventHandler.setup(new ToolSword(MaterialsRegistry.JADE_TOOLS), "jade_sword"), EventHandler.setup(new ItemRubyHorseArmor(), "ruby_horse_armor"), EventHandler.setup(new ItemAmethystHorseArmor(), "amethyst_horse_armor"), EventHandler.setup(new ItemJadeHorseArmor(), "jade_horse_armor"), EventHandler.setup(new ItemTatami(), "tatami"), EventHandler.setup(new ItemTatamiHalf(), "tatami_half"), EventHandler.setup(new ItemRice(), "rice"), (Item)EventHandler.setup(new ItemFood(2, 0.1f, false), "dried_fruits"), (Item)EventHandler.setup(new ItemFood(2, 0.1f, false), "cheese"), EventHandler.setup(new ItemFood(6, 0.6f, false){

            public EnumRarity func_77613_e(ItemStack stack) {
                return RarityHandler.WELSH;
            }
        }.func_77625_d(16), "welsh_cakes"), (Item)EventHandler.setup(new ItemFood(5, 0.6f, false){

            public EnumRarity func_77613_e(ItemStack stack) {
                return RarityHandler.WELSH;
            }
        }, "welsh_rarebit"), (Item)EventHandler.setup(new ItemFood(2, 0.3f, true).func_185070_a(new PotionEffect(MobEffects.field_76438_s, 600, 0), 0.3f), "lamb_shank"), (Item)EventHandler.setup(new ItemFood(7, 0.8f, true), "lamb_shank_cooked"), (Item)EventHandler.setup(new ItemNoctiluca(2, 0.1f, false), "noctiluca"), (Item)EventHandler.setup(new ItemSeedFood(2, 0.4f, BlockReg.LEEK_CROP, Blocks.field_150458_ak), "leek"), (Item)EventHandler.setup(new ItemSoup(8).func_77848_i(), "rice_bowl"), (Item)EventHandler.setup(new ItemSoup(8).func_77848_i(), "leek_bowl"), (Item)EventHandler.setup(new ItemCawl(16).func_77848_i(), "cawl_bowl"), EventHandler.setup(new Item(), "rice_straw"), EventHandler.setup(new ItemBuilder(), "builder"), (Item)EventHandler.setup(new ItemWelshShield(2048), "welsh_shield"), (Item)EventHandler.setup(new ItemExplorerArmor(MaterialsRegistry.WIZARD_HAT, EntityEquipmentSlot.HEAD), "wizard_hat"), EventHandler.setup(new ItemWizardStaff(), "wizard_staff"), (Item)EventHandler.setup(new ItemDoor((Block)BlockReg.ASH_DOOR), "ash_door"), (Item)EventHandler.setup(new ItemDoor((Block)BlockReg.BAMBOO_DOOR), "bamboo_door"), (Item)EventHandler.setup(new ItemDoor((Block)BlockReg.CHERRY_DOOR), "cherry_door"), (Item)EventHandler.setup(new ItemDoor((Block)BlockReg.MAPLE_DOOR), "maple_door"), (Item)EventHandler.setup(new ItemSlab((Block)BlockReg.BASALT_BRICK_SLAB_HALF, BlockReg.BASALT_BRICK_SLAB_HALF, BlockReg.BASALT_BRICK_SLAB_DOUBLE), BlockReg.BASALT_BRICK_SLAB_HALF.getRegistryName()), (Item)EventHandler.setup(new ItemSlab((Block)BlockReg.MARBLE_BRICK_SLAB_HALF, BlockReg.MARBLE_BRICK_SLAB_HALF, BlockReg.MARBLE_BRICK_SLAB_DOUBLE), BlockReg.MARBLE_BRICK_SLAB_HALF.getRegistryName()), (Item)EventHandler.setup(new ItemSlab((Block)BlockReg.SLATE_BRICK_SLAB_HALF, BlockReg.SLATE_BRICK_SLAB_HALF, BlockReg.SLATE_BRICK_SLAB_DOUBLE), BlockReg.SLATE_BRICK_SLAB_HALF.getRegistryName()), (Item)EventHandler.setup(new ItemSlab((Block)BlockReg.ASH_SLAB_HALF, BlockReg.ASH_SLAB_HALF, BlockReg.ASH_SLAB_DOUBLE), BlockReg.ASH_SLAB_HALF.getRegistryName()), (Item)EventHandler.setup(new ItemSlab((Block)BlockReg.BAMBOO_SLAB_HALF, BlockReg.BAMBOO_SLAB_HALF, BlockReg.BAMBOO_SLAB_DOUBLE), BlockReg.BAMBOO_SLAB_HALF.getRegistryName()), (Item)EventHandler.setup(new ItemSlab((Block)BlockReg.CHERRY_SLAB_HALF, BlockReg.CHERRY_SLAB_HALF, BlockReg.CHERRY_SLAB_DOUBLE), BlockReg.CHERRY_SLAB_HALF.getRegistryName()), (Item)EventHandler.setup(new ItemSlab((Block)BlockReg.MAPLE_SLAB_HALF, BlockReg.MAPLE_SLAB_HALF, BlockReg.MAPLE_SLAB_DOUBLE), BlockReg.MAPLE_SLAB_HALF.getRegistryName())});
        ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block.getRegistryName().func_110624_b().equals("explorercraft")).filter(EventHandler::hasItemBlock).forEach(block -> registry.register((IForgeRegistryEntry)EventHandler.setup(new ItemBlock(block), block.getRegistryName())));
        LOGGER.debug("Registered items");
    }

    private static boolean hasItemBlock(@Nonnull Block block) {
        if (block == BlockReg.TATAMI || block == BlockReg.TATAMI_HALF || block == BlockReg.RICE_BASE || block == BlockReg.RICE_TOP || block == BlockReg.LEEK_CROP || block == BlockReg.NOCTILUCA_PLANT) {
            return false;
        }
        return !(block instanceof BlockSlab) && !(block instanceof BlockDoor);
    }

    @SubscribeEvent
    public static void onRegisterEntitiesEvent(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        ResourceLocation EntityWizard2 = new ResourceLocation("explorercraft", "wizard");
        ResourceLocation EntityEnderreeper2 = new ResourceLocation("explorercraft", "enderreeper");
        ResourceLocation EntityEnderghast2 = new ResourceLocation("explorercraft", "enderghast");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{EntityEntryBuilder.create().entity(EntityWizard.class).id(EntityWizard2, entityId++).name(EntityWizard2.func_110623_a()).tracker(32, 1, true).egg(3093067, 0xFFFFFF).build(), EntityEntryBuilder.create().entity(EntityEnderreeper.class).id(EntityEnderreeper2, entityId++).name(EntityEnderreeper2.func_110623_a()).tracker(32, 1, true).egg(MapColor.field_151646_E.field_76291_p, MapColor.field_151678_z.field_76291_p).spawn(EnumCreatureType.MONSTER, 2, 1, 1, EventHandler.getBiomes(BiomeDictionary.Type.END)).build(), EntityEntryBuilder.create().entity(EntityEnderghast.class).id(EntityEnderghast2, entityId++).name(EntityEnderghast2.func_110623_a()).tracker(64, 1, true).egg(4801171, 6078066).spawn(EnumCreatureType.MONSTER, 5, 1, 1, EventHandler.getBiomes(BiomeDictionary.Type.END)).build()});
        LOGGER.debug("Registered entities");
    }

    private static Biome[] getBiomes(BiomeDictionary.Type type) {
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)type).toArray(new Biome[0]);
    }

    @Nonnull
    public static <T extends IForgeRegistryEntry> T setup(@Nonnull T entry, @Nonnull String name) {
        return EventHandler.setup(entry, new ResourceLocation("explorercraft", name));
    }

    @Nonnull
    public static <T extends IForgeRegistryEntry> T setup(@Nonnull T entry, @Nonnull ResourceLocation registryName) {
        Preconditions.checkNotNull(entry, (Object)"entry to setup must not be null!");
        Preconditions.checkNotNull((Object)registryName, (Object)"registryName to assign must not be null!");
        entry.setRegistryName(registryName);
        if (entry instanceof Block) {
            ((Block)entry).func_149663_c(registryName.func_110624_b() + "." + registryName.func_110623_a()).func_149647_a((CreativeTabs)ExplorercraftTab.instance);
        }
        if (entry instanceof Item) {
            ((Item)entry).func_77655_b(registryName.func_110624_b() + "." + registryName.func_110623_a()).func_77637_a((CreativeTabs)ExplorercraftTab.instance);
        }
        return entry;
    }
}

