/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.test;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import zathrox.explorercraft.blocks.BlockRiceTop;
import zathrox.explorercraft.init.BlockReg;
import zathrox.explorercraft.world.test.WorldGenAbstract;

public class PopulateChunkRicelake
extends WorldGenAbstract {
    private static final Random randomAge = new Random();
    private static final IBlockState water = Blocks.field_150358_i.func_176223_P();
    private static final IBlockState base = BlockReg.RICE_BASE.func_176223_P();
    private static final IBlockState top = BlockReg.RICE_TOP.func_176223_P().func_177226_a((IProperty)BlockRiceTop.AGE, (Comparable)Integer.valueOf(0 + randomAge.nextInt(6)));

    public PopulateChunkRicelake(World world, Random rand) {
        super(world, rand);
    }

    @Override
    public void generateChunk(int xChunk, int zChunk) {
        BlockPos start;
        BlockPos position = start = new BlockPos(xChunk * 16 + this.rand.nextInt(16), 256, zChunk * 16 + this.rand.nextInt(16));
        while (position.func_177956_o() > 5 && this.world.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        if (position.func_177956_o() <= 4) {
            return;
        }
        position = position.func_177979_c(4);
        boolean[] aboolean = new boolean[2048];
        int i = this.rand.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = this.rand.nextDouble() * 6.0 + 3.0;
            double d1 = this.rand.nextDouble() * 4.0 + 2.0;
            double d2 = this.rand.nextDouble() * 6.0 + 3.0;
            double d3 = this.rand.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = this.rand.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = this.rand.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l2 = 0; l2 < 16; ++l2) {
                for (int k = 0; k < 8; ++k) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + l2) * 8 + k] && (k1 < 15 && aboolean[((k1 + 1) * 16 + l2) * 8 + k] || k1 > 0 && aboolean[((k1 - 1) * 16 + l2) * 8 + k] || l2 < 15 && aboolean[(k1 * 16 + l2 + 1) * 8 + k] || l2 > 0 && aboolean[(k1 * 16 + (l2 - 1)) * 8 + k] || k < 7 && aboolean[(k1 * 16 + l2) * 8 + k + 1] || k > 0 && aboolean[(k1 * 16 + l2) * 8 + (k - 1)]);
                    if (!flag) continue;
                    Material material = this.world.func_180495_p(position.func_177982_a(k1, k, l2)).func_185904_a();
                    if (k >= 4 && material.func_76224_d()) {
                        return;
                    }
                    if (k >= 4 || material.func_76220_a() || this.world.func_180495_p(position.func_177982_a(k1, k, l2)).func_177230_c() == water.func_177230_c()) continue;
                    return;
                }
            }
        }
        ArrayList<BlockPos> possibles = new ArrayList<BlockPos>();
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 8; ++i4) {
                    if (!aboolean[(l1 * 16 + i3) * 8 + i4]) continue;
                    BlockPos target = position.func_177982_a(l1, i4, i3);
                    if (i4 >= 4) {
                        if (this.world.func_180495_p(target) == top || this.world.func_180495_p(target) == base) continue;
                        this.world.func_180501_a(target, Blocks.field_150350_a.func_176223_P(), 2);
                        continue;
                    }
                    this.world.func_180501_a(target, water, 2);
                    Block below = this.world.func_180495_p(target.func_177977_b()).func_177230_c();
                    if (below != Blocks.field_150346_d && below != Blocks.field_150349_c && below != Blocks.field_150354_m) continue;
                    possibles.add(target);
                }
            }
        }
        int riceCount = 0;
        int riceMax = this.rand.nextInt(6) + 1;
        while (riceCount <= riceMax && possibles.size() > 0) {
            BlockPos rice = (BlockPos)possibles.remove(this.rand.nextInt(possibles.size()));
            if (!this.world.func_175678_i(rice.func_177984_a()) || !this.world.func_175623_d(rice.func_177984_a())) continue;
            this.world.func_180501_a(rice, base, 2);
            this.world.func_180501_a(rice.func_177984_a(), top, 2);
            System.out.println(rice);
            ++riceCount;
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                for (int j4 = 4; j4 < 8; ++j4) {
                    BlockPos blockpos;
                    if (!aboolean[(i2 * 16 + j3) * 8 + j4] || this.world.func_180495_p(blockpos = position.func_177982_a(i2, j4 - 1, j3)).func_177230_c() != Blocks.field_150346_d || this.world.func_175642_b(EnumSkyBlock.SKY, position.func_177982_a(i2, j4, j3)) <= 0) continue;
                    Biome biome = this.world.func_180494_b(blockpos);
                    if (biome.field_76752_A.func_177230_c() == Blocks.field_150391_bh) {
                        this.world.func_180501_a(blockpos, Blocks.field_150391_bh.func_176223_P(), 2);
                        continue;
                    }
                    this.world.func_180501_a(blockpos, Blocks.field_150349_c.func_176223_P(), 2);
                }
            }
        }
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int l3 = 0; l3 < 16; ++l3) {
                if (!this.world.func_175675_v(position.func_177982_a(k2, 4, l3))) continue;
                this.world.func_180501_a(position.func_177982_a(k2, 4, l3), Blocks.field_150432_aD.func_176223_P(), 2);
            }
        }
    }
}

