/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.util;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.BannerPattern;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import zathrox.explorercraft.init.BiomesRegistry;
import zathrox.explorercraft.init.BlockReg;
import zathrox.explorercraft.init.ItemReg;
import zathrox.explorercraft.init.MaterialsRegistry;
import zathrox.explorercraft.init.OreDictionaryRegistry;
import zathrox.explorercraft.init.RecipesRegistry;
import zathrox.explorercraft.tab.ExplorercraftTab;
import zathrox.explorercraft.util.LootHandler;
import zathrox.explorercraft.world.WorldGenExplorer;
import zathrox.explorercraft.world.WorldGenStructures;
import zathrox.explorercraft.world.WorldTypeBiomeTest;

public class RegistryHandler {
    public static void preInitRegistries() {
        ExplorercraftTab.init();
    }

    public static void initRegistries() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenExplorer(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenStructures(), (int)0);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new WorldGenExplorer());
        BiomesRegistry.registerBiomes();
        RecipesRegistry.init();
        MaterialsRegistry.init();
        OreDictionaryRegistry.init();
        MinecraftForge.EVENT_BUS.register((Object)new LootHandler());
        RegistryHandler.bannerRegistry();
    }

    public static void postInitRegistries() {
        WorldTypeBiomeTest EXPLORERTEST = new WorldTypeBiomeTest();
    }

    public static void bannerRegistry() {
        RegistryHandler.addBanner("welshdragon", new ItemStack(ItemReg.LEEK, 1));
        RegistryHandler.addBanner("welshflag", new ItemStack(BlockReg.DRAGON_HEART, 1));
        RegistryHandler.addBanner("wales", new ItemStack(BlockReg.SLATE, 1));
    }

    public static BannerPattern addBanner(String name, ItemStack craftingStack) {
        Class[] classes = new Class[]{String.class, String.class, ItemStack.class};
        Object[] names = new Object[]{name, "explorercraft." + name, craftingStack};
        return (BannerPattern)EnumHelper.addEnum(BannerPattern.class, (String)name.toUpperCase(), (Class[])classes, (Object[])names);
    }
}

