/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.world.biome;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenSand;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zathrox.explorercraft.world.trees.WorldGenBambooTree;
import zathrox.explorercraft.world.trees.WorldGenJapaneseMaple;
import zathrox.explorercraft.world.trees.WorldGenKwanzanCherry;

public class BiomeBambooForest
extends Biome {
    private static final IBlockState OAK_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
    private static final IBlockState OAK_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    public static final WorldGenBlockBlob FOREST_ROCK_GENERATOR = new WorldGenBlockBlob(Blocks.field_150341_Y, 0);
    public WorldGenerator sandGen = new WorldGenSand((Block)Blocks.field_150354_m, 7);
    public WorldGenerator mossyGen = new WorldGenSand(Blocks.field_150341_Y, 3);
    public int mossyPatchesPerChunk = 3;

    public BiomeBambooForest(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76760_I.field_76832_z = 30;
        this.field_76760_I.field_76803_B = 15;
        this.field_76760_I.field_76802_A = 0;
        this.field_76760_I.field_76833_y = 2;
        this.field_76760_I.field_76805_H = 3;
        this.field_76760_I.field_76801_G = 0;
        this.field_76760_I.field_76808_K = true;
    }

    public void func_180624_a(World worldIn, Random random, BlockPos pos) {
        super.func_180624_a(worldIn, random, pos);
        ChunkPos forgeChunkPos = new ChunkPos(pos);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(worldIn, random, forgeChunkPos));
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ROCK)) {
            int i2 = random.nextInt(3);
            for (int j2 = 0; j2 < i2; ++j2) {
                int k2 = random.nextInt(16) + 8;
                int l2 = random.nextInt(16) + 8;
                BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(k2, 1, l2));
                FOREST_ROCK_GENERATOR.func_180709_b(worldIn, random, blockpos);
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND)) {
            for (int i = 0; i < this.field_76760_I.field_76805_H; ++i) {
                int j = random.nextInt(16) + 8;
                int k = random.nextInt(16) + 8;
                this.sandGen.func_180709_b(worldIn, random, worldIn.func_175672_r(pos.func_177982_a(j, 0, k)));
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND_PASS2)) {
            for (int j1 = 0; j1 < this.mossyPatchesPerChunk; ++j1) {
                int i2 = random.nextInt(16) + 8;
                int j6 = random.nextInt(16) + 8;
                this.mossyGen.func_180709_b(worldIn, random, worldIn.func_175672_r(pos.func_177982_a(i2, 1, j6)));
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(worldIn, random, forgeChunkPos));
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(400) == 0) {
            return new WorldGenJapaneseMaple(false);
        }
        if (random.nextInt(275) == 1) {
            return new WorldGenKwanzanCherry(false);
        }
        if (random.nextInt(25) == 2) {
            return new WorldGenShrub(OAK_LOG, OAK_LEAF);
        }
        return new WorldGenBambooTree(false);
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        if (noiseVal > 1.75) {
            this.field_76752_A = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
        }
        this.func_180628_b(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public WorldGenerator func_76730_b(Random rand) {
        return rand.nextInt(4) == 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        double d0 = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return this.getModdedBiomeGrassColor(9430372);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(9430372);
    }
}

