/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.animation.controller;

import goblinbob.mobends.core.animation.bit.AnimationBit;
import goblinbob.mobends.core.animation.controller.IAnimationController;
import goblinbob.mobends.core.animation.layer.HardAnimationLayer;
import goblinbob.mobends.standard.animation.bit.biped.JumpAnimationBit;
import goblinbob.mobends.standard.animation.bit.biped.item.BipedActionController;
import goblinbob.mobends.standard.animation.bit.skeleton.StandAnimationBit;
import goblinbob.mobends.standard.animation.bit.skeleton.WalkAnimationBit;
import goblinbob.mobends.standard.data.BipedEntityData;
import goblinbob.mobends.standard.data.SkeletonData;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;

public class SkeletonController
implements IAnimationController<SkeletonData> {
    protected HardAnimationLayer<BipedEntityData<EntitySkeleton>> layerBase;
    protected AnimationBit<? extends BipedEntityData<EntitySkeleton>> bitStand;
    protected AnimationBit<? extends BipedEntityData<EntitySkeleton>> bitWalk;
    protected AnimationBit<? extends BipedEntityData<EntitySkeleton>> bitJump;
    protected final BipedActionController actionController = new BipedActionController();

    public SkeletonController() {
        this.layerBase = new HardAnimationLayer();
        this.bitStand = new StandAnimationBit();
        this.bitWalk = new WalkAnimationBit();
        this.bitJump = new JumpAnimationBit<BipedEntityData<EntitySkeleton>>();
    }

    public void performActionAnimations(SkeletonData data, EntitySkeleton skeleton) {
        EnumHandSide primaryHand = skeleton.func_184591_cq();
        ItemStack heldItemMainhand = skeleton.func_184614_ca();
        ItemStack heldItemOffhand = skeleton.func_184592_cb();
        Item activeItem = skeleton.func_184607_cu().func_77973_b();
        this.actionController.perform(data, primaryHand, heldItemMainhand, heldItemOffhand, activeItem);
    }

    @Override
    public Collection<String> perform(SkeletonData skeletonData) {
        EntitySkeleton skeleton = (EntitySkeleton)skeletonData.getEntity();
        if (!skeletonData.isOnGround() || skeletonData.getTicksAfterTouchdown() < 1.0f) {
            this.layerBase.playOrContinueBit(this.bitJump, skeletonData);
        } else if (skeletonData.isStillHorizontally()) {
            this.layerBase.playOrContinueBit(this.bitStand, skeletonData);
        } else {
            this.layerBase.playOrContinueBit(this.bitWalk, skeletonData);
        }
        ArrayList<String> actions = new ArrayList<String>();
        this.layerBase.perform(skeletonData, actions);
        this.performActionAnimations(skeletonData, skeleton);
        return actions;
    }
}

