/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.plants;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import paulevs.betternether.blocks.BlockBrownLargeMushroom;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.structures.IStructure;

public class StructureMedBrownMushroom
implements IStructure {
    @Override
    public void generate(World world, BlockPos pos, Random random) {
        Block under = world.func_180495_p(pos).func_177230_c();
        if (under instanceof BlockNetherrack || under == Blocks.field_150425_aM) {
            for (int i = 0; i < 10; ++i) {
                BlockPos npos;
                int x = pos.func_177958_n() + (int)(random.nextGaussian() * 2.0);
                int z = pos.func_177952_p() + (int)(random.nextGaussian() * 2.0);
                int y = pos.func_177956_o() + random.nextInt(6);
                for (int j = 0; j < 6 && (npos = new BlockPos(x, y - j, z)).func_177956_o() > 31; ++j) {
                    under = world.func_180495_p(npos.func_177977_b()).func_177230_c();
                    if (under != BlocksRegister.BLOCK_NETHER_MYCELIUM) continue;
                    this.grow(world, npos, random);
                }
            }
        }
    }

    private void grow(World world, BlockPos pos, Random random) {
        int size = 2 + random.nextInt(3);
        for (int y = 1; y <= size; ++y) {
            if (world.func_180495_p(pos.func_177981_b(y)).func_177230_c() == Blocks.field_150350_a) continue;
            size = y - 1;
            break;
        }
        boolean hasAir = true;
        if (size > 2) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    hasAir = hasAir && world.func_180495_p(pos.func_177981_b(size).func_177982_a(x, 0, z)).func_177230_c() == Blocks.field_150350_a;
                }
            }
        }
        if (hasAir && size > 2) {
            IBlockState middle = BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.MIDDLE));
            world.func_175656_a(pos, BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P());
            for (int y = 1; y < size; ++y) {
                world.func_175656_a(pos.func_177981_b(y), middle);
            }
            pos = pos.func_177981_b(size);
            world.func_175656_a(pos, BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.TOP)));
            world.func_175656_a(pos.func_177978_c(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.SIDE_N)));
            world.func_175656_a(pos.func_177968_d(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.SIDE_S)));
            world.func_175656_a(pos.func_177974_f(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.SIDE_E)));
            world.func_175656_a(pos.func_177976_e(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.SIDE_W)));
            world.func_175656_a(pos.func_177978_c().func_177974_f(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.CORNER_N)));
            world.func_175656_a(pos.func_177978_c().func_177976_e(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.CORNER_W)));
            world.func_175656_a(pos.func_177968_d().func_177974_f(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.CORNER_E)));
            world.func_175656_a(pos.func_177968_d().func_177976_e(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.CORNER_S)));
        }
    }
}

