/*
 * Decompiled with CFR 0.152.
 */
package meldexun.reachfix;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import meldexun.reachfix.config.ReachFixConfig;
import meldexun.reachfix.network.CPacketHandlerSyncConfig;
import meldexun.reachfix.network.SPacketSyncConfig;
import meldexun.reachfix.util.ReachFixUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class ReachFix
extends DummyModContainer {
    public static final String MOD_ID = "reachfix";
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("reachfix");

    public ReachFix() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.name = "Reach Fix";
        meta.version = "1.0.5";
        meta.modId = MOD_ID;
        meta.authorList = Arrays.asList("Meldexun");
        meta.url = "https://github.com/Meldexun/ReachFix";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void onFMLConstructionEvent(FMLConstructionEvent event) {
        ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        NETWORK.registerMessage(CPacketHandlerSyncConfig.class, SPacketSyncConfig.class, 1, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Subscribe
    public void onFMLServerStartingEvent(FMLServerStartingEvent event) {
        ReachFixUtil.setEnabled(ReachFixConfig.enabled);
        ReachFixUtil.setReach(ReachFixConfig.reach);
        ReachFixUtil.setReachCreative(ReachFixConfig.reachCreative);
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        NETWORK.sendTo((IMessage)new SPacketSyncConfig(ReachFixConfig.enabled, ReachFixConfig.reach, ReachFixConfig.reachCreative), (EntityPlayerMP)event.player);
        ReachFixUtil.updateBaseReachModifier(event.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        ReachFixUtil.updateBaseReachModifier(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        ReachFixUtil.updateBaseReachModifier(event.player);
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        }
    }
}

