/*
 * Decompiled with CFR 0.152.
 */
package meldexun.reachfix.hook.client;

import java.util.List;
import javax.annotation.Nullable;
import meldexun.reachfix.util.ReachFixUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class EntityRendererHook {
    public static void getMouseOver(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.func_175606_aa();
        if (viewEntity == null) {
            return;
        }
        if (mc.field_71441_e == null) {
            return;
        }
        mc.field_71424_I.func_76320_a("pick");
        RayTraceResult pointedBlock = EntityRendererHook.getPointedBlock(partialTicks);
        RayTraceResult pointedEntity = EntityRendererHook.getPointedEntity(partialTicks);
        if (pointedBlock != null) {
            double d2;
            Vec3d start;
            double d1;
            mc.field_71476_x = pointedEntity != null ? ((d1 = pointedBlock.field_72307_f.func_72436_e(start = viewEntity.func_174824_e(partialTicks))) <= (d2 = pointedEntity.field_72307_f.func_72436_e(start)) ? pointedBlock : pointedEntity) : pointedBlock;
        } else if (pointedEntity != null) {
            mc.field_71476_x = pointedEntity;
        } else {
            double reach = mc.field_71442_b.func_78757_d();
            Vec3d dir = viewEntity.func_70676_i(partialTicks).func_186678_a(reach);
            Vec3d start = viewEntity.func_174824_e(partialTicks);
            Vec3d end = start.func_178787_e(dir);
            mc.field_71476_x = new RayTraceResult(RayTraceResult.Type.MISS, end, null, new BlockPos(end));
        }
        mc.field_71460_t.field_78528_u = mc.field_71476_x.field_72308_g;
        mc.field_147125_j = mc.field_71476_x.field_72308_g;
        mc.field_71424_I.func_76319_b();
    }

    @Nullable
    private static RayTraceResult getPointedBlock(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.func_175606_aa();
        if (viewEntity == null) {
            return null;
        }
        if (mc.field_71441_e == null) {
            return null;
        }
        double reach = ReachFixUtil.getBlockReach((EntityPlayer)mc.field_71439_g);
        RayTraceResult result = viewEntity.func_174822_a(reach, partialTicks);
        if (result != null && result.field_72313_a == RayTraceResult.Type.MISS) {
            return null;
        }
        return result;
    }

    @Nullable
    private static RayTraceResult getPointedEntity(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.func_175606_aa();
        if (viewEntity == null) {
            return null;
        }
        if (mc.field_71441_e == null) {
            return null;
        }
        double reach = ReachFixUtil.getEntityReach((EntityPlayer)mc.field_71439_g);
        Vec3d dir = viewEntity.func_70676_i(partialTicks).func_186678_a(reach);
        AxisAlignedBB aabb = viewEntity.func_174813_aQ();
        aabb = aabb.func_72321_a(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        aabb = aabb.func_186662_g(1.0);
        List possibleEntities = mc.field_71441_e.func_175674_a(viewEntity, aabb, entity -> {
            if (!EntitySelectors.field_180132_d.apply(entity)) {
                return false;
            }
            return entity.func_70067_L();
        });
        Vec3d start = viewEntity.func_174824_e(partialTicks);
        Vec3d end = start.func_178787_e(dir);
        RayTraceResult result = null;
        Entity pointedEntity = null;
        double min = Double.MAX_VALUE;
        for (Entity entity2 : possibleEntities) {
            double dist;
            if (viewEntity.func_184208_bv() == entity2.func_184208_bv() && !entity2.canRiderInteract()) continue;
            AxisAlignedBB entityAabb = EntityRendererHook.getInterpolatedAABB(entity2, partialTicks);
            if (entityAabb.func_72318_a(start)) {
                return new RayTraceResult(entity2, start);
            }
            RayTraceResult rtr = entityAabb.func_72327_a(start, end);
            if (rtr == null || rtr.field_72313_a == RayTraceResult.Type.MISS || !((dist = start.func_72436_e(rtr.field_72307_f)) < min)) continue;
            result = rtr;
            pointedEntity = entity2;
            min = dist;
        }
        if (result == null || result.field_72313_a == RayTraceResult.Type.MISS) {
            return null;
        }
        return new RayTraceResult(pointedEntity, result.field_72307_f);
    }

    private static AxisAlignedBB getInterpolatedAABB(Entity entity, float partialTicks) {
        AxisAlignedBB aabb = entity.func_174813_aQ();
        float collisionBorderSize = entity.func_70111_Y();
        if (collisionBorderSize != 0.0f) {
            aabb = aabb.func_186662_g((double)collisionBorderSize);
        }
        if (partialTicks != 0.0f) {
            double x = -(entity.field_70165_t - entity.field_70142_S) * (1.0 - (double)partialTicks);
            double y = -(entity.field_70163_u - entity.field_70137_T) * (1.0 - (double)partialTicks);
            double z = -(entity.field_70161_v - entity.field_70136_U) * (1.0 - (double)partialTicks);
            aabb = aabb.func_72317_d(x, y, z);
        }
        return aabb;
    }
}

