/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.bookworm.util;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.soggymustache.bookworm.common.entity.data.Gender;

public class BookwormUtils {
    public static boolean isFloatWithinBounds(float check, float min, float max) {
        return check <= max && check >= min;
    }

    public static BlockPos vecToBlockPos(Vec3d vec) {
        return new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static boolean movingUp(Entity entity) {
        return entity.field_70163_u > entity.field_70167_r;
    }

    public static boolean movingDown(Entity entity) {
        return entity.field_70163_u < entity.field_70167_r;
    }

    public static boolean isEntityRotating(EntityLivingBase entity) {
        return entity.field_70760_ar != entity.field_70761_aq;
    }

    public static Gender getGenderFromValue(int i) {
        switch (i) {
            default: {
                return Gender.FEMALE;
            }
            case 1: 
        }
        return Gender.MALE;
    }

    public static String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public static boolean isEntityMoving(Entity e) {
        return e.field_70165_t != e.field_70169_q && e.field_70161_v != e.field_70166_s;
    }

    public static int getAgeTForDays(int days) {
        return days * 23960 - days * 23960 * 2;
    }

    public static boolean blockAtPos(World worldObj, Block block, double posX, double posY, double posZ) {
        Block blockAt = worldObj.func_180495_p(new BlockPos((int)posX, (int)posY, (int)posZ)).func_177230_c();
        return blockAt == block;
    }

    public static Block getBlockAtPos(World worldObj, double posX, double posY, double posZ) {
        return worldObj.func_180495_p(new BlockPos((int)posX, (int)posY, (int)posZ)).func_177230_c();
    }

    public static Entity getClosestEntityToEntity(Entity target, Entity e, double distance) {
        return BookwormUtils.getClosestEntity2(target.getClass(), e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, distance);
    }

    public static Entity getClosestEntityToPlayer(EntityPlayer entityIn, double distance) {
        return BookwormUtils.getClosestEntity(entityIn.field_70170_p, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, distance);
    }

    public static Entity getClosestEntity2(Class search, World world, double x, double y, double z, double distance) {
        double d4 = -1.0;
        Entity entityFound = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity currE = (Entity)world.field_72996_f.get(i);
            if (currE.getClass() == search) continue;
            double d5 = currE.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(d5 < distance * distance) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityFound = currE;
        }
        return entityFound;
    }

    public static Entity getClosestEntity(World world, double x, double y, double z, double distance) {
        double d4 = -1.0;
        Entity entityFound = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity currE = (Entity)world.field_72996_f.get(i);
            if (currE instanceof EntityPlayer) continue;
            double d5 = currE.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(d5 < distance * distance) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityFound = currE;
        }
        return entityFound;
    }

    @Nullable
    public static Entity findEntityOnPath(EntityPlayer player, float distance, Vec3d start, Vec3d end, Predicate entityPredicate) {
        Entity entity = null;
        List list = player.field_70170_p.func_175674_a((Entity)player, player.func_174813_aQ().func_72321_a((double)distance, (double)distance, (double)distance).func_186662_g(1.0), entityPredicate);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == player || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }
}

