/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PlayerWaystoneData {
    private final WaystoneEntry[] entries;
    private final long lastFreeWarp;
    private final long lastWarpStoneUse;

    public PlayerWaystoneData(WaystoneEntry[] entries, long lastFreeWarp, long lastWarpStoneUse) {
        this.entries = entries;
        this.lastFreeWarp = lastFreeWarp;
        this.lastWarpStoneUse = lastWarpStoneUse;
    }

    public WaystoneEntry[] getWaystones() {
        return this.entries;
    }

    public long getLastFreeWarp() {
        return this.lastFreeWarp;
    }

    public long getLastWarpStoneUse() {
        return this.lastWarpStoneUse;
    }

    public void store(EntityPlayerMP player) {
        PlayerWaystoneHelper.store((EntityPlayer)player, this.entries, this.lastFreeWarp, this.lastWarpStoneUse);
    }

    public static PlayerWaystoneData fromPlayer(EntityPlayer player) {
        NBTTagCompound tagCompound = PlayerWaystoneHelper.getWaystonesTag(player);
        NBTTagList tagList = tagCompound.func_150295_c("WaystoneList", 10);
        WaystoneEntry[] entries = new WaystoneEntry[tagList.func_74745_c()];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = WaystoneEntry.read(tagList.func_150305_b(i));
        }
        long lastFreeWarp = tagCompound.func_74763_f("LastFreeWarp");
        long lastWarpStoneUse = tagCompound.func_74763_f("LastWarpStoneUse");
        return new PlayerWaystoneData(entries, lastFreeWarp, lastWarpStoneUse);
    }
}

