/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.config.ConfigBlockDestruction;
import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.config.ConfigDynamicDifficulty;
import CoroUtil.config.ConfigHWMonsters;
import CoroUtil.difficulty.data.DifficultyDataReader;
import CoroUtil.diplomacy.TeamTypes;
import CoroUtil.forge.CULog;
import CoroUtil.forge.CommandCoroUtil;
import CoroUtil.forge.CommonProxy;
import CoroUtil.forge.EventHandlerFML;
import CoroUtil.forge.EventHandlerForge;
import CoroUtil.forge.EventHandlerPacket;
import CoroUtil.pets.PetsManager;
import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.util.CoroUtilFile;
import CoroUtil.util.CoroUtilMisc;
import CoroUtil.world.WorldDirectorManager;
import com.google.common.collect.BiMap;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import modconfig.ConfigMod;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="coroutil", name="coroutil", version="1.12.1-1.2.37", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.1]")
public class CoroUtil {
    @Mod.Instance(value="coroutil")
    public static CoroUtil instance;
    public static final String modID = "coroutil";
    public static final String modID_HWMonsters = "hw_monsters";
    public static final String modID_HWInvasions = "hw_inv";
    public static final String version = "1.12.1-1.2.37";
    @SidedProxy(clientSide="CoroUtil.forge.ClientProxy", serverSide="CoroUtil.forge.CommonProxy")
    public static CommonProxy proxy;
    public static boolean initProperNeededForInstance;
    public static String eventChannelName;
    public static final FMLEventChannel eventChannel;
    public static ConfigCoroUtil configCoroUtil;
    public static ConfigCoroUtilAdvanced configDev;
    public static ConfigDynamicDifficulty configDD;
    public static ConfigHWMonsters configHWMonsters;
    public static ConfigBlockDestruction configBlockDestruction;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CoroUtil.migrateOldConfig();
        ConfigMod.addConfigFile(event, configCoroUtil);
        ConfigMod.addConfigFile(event, configBlockDestruction);
        configDev.hookUpdatedValues();
        configDD.hookUpdatedValues();
        configHWMonsters.hookUpdatedValues();
        DifficultyDataReader.init();
        DifficultyDataReader.loadFiles();
        eventChannel.register((Object)new EventHandlerPacket());
    }

    public static void migrateOldConfig() {
        File path = new File("." + File.separator + "config" + File.separator + "CoroUtil");
        try {
            path.mkdirs();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        File oldFile = new File("." + File.separator + "config" + File.separator + "CoroUtil.cfg");
        File newFile = new File("." + File.separator + "config" + File.separator + "CoroUtil" + File.separator + "General.cfg");
        CoroUtil.fixConfigFile(oldFile, newFile, "coroutil {", "general {");
        oldFile = new File("." + File.separator + "config" + File.separator + "CoroUtil_DynamicDifficulty.cfg");
        newFile = new File("." + File.separator + "config" + File.separator + "CoroUtil" + File.separator + "DynamicDifficulty.cfg");
        CoroUtil.fixConfigFile(oldFile, newFile, "coroutil_dynamicdifficulty {", "dynamicdifficulty {");
    }

    public static void fixConfigFile(File oldFile, File newFile, String oldCat, String newCat) {
        if (oldFile.exists() && !newFile.exists()) {
            CULog.log("Detected old " + oldFile.toString() + ", relocating to " + newFile.toString());
            try {
                Files.move(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ArrayList<String> newLines = new ArrayList<String>();
                for (String line : Files.readAllLines(newFile.toPath(), StandardCharsets.UTF_8)) {
                    if (line.contains(oldCat)) {
                        newLines.add(line.replace(oldCat, newCat));
                        continue;
                    }
                    newLines.add(line);
                }
                Files.write(newFile.toPath(), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerFML());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerForge());
        proxy.init(this);
        TeamTypes.initTypes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        boolean debugOutputEntityRegistrations = false;
        if (debugOutputEntityRegistrations) {
            try {
                BiMap entityClassRegistrations = (BiMap)ObfuscationReflectionHelper.getPrivateValue(EntityRegistry.class, (Object)EntityRegistry.instance(), (String[])new String[]{"entityClassRegistrations"});
                for (EntityRegistry.EntityRegistration entityRegistration : entityClassRegistrations.values()) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ConfigCoroUtilAdvanced.fixBadBiomeEntitySpawnEntries) {
            CULog.log("fixBadBiomeEntitySpawnEntries enabled, scanning and fixing all biome entity spawn lists for potential crash risks");
            CoroUtilMisc.fixBadBiomeEntitySpawns();
        }
    }

    public void postInit() {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCoroUtil());
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        CoroUtil.writeOutData(true);
        initProperNeededForInstance = true;
    }

    public static void initTry() {
        if (initProperNeededForInstance) {
            CULog.log("CoroUtil being reinitialized");
            initProperNeededForInstance = false;
            CoroUtilFile.getWorldFolderName();
            PetsManager.instance().nbtReadFromDisk();
            WorldDirectorManager.instance().reset();
        }
    }

    public static void writeOutData(boolean unloadInstances) {
        try {
            if (ConfigCoroUtilAdvanced.useCoroPets) {
                PetsManager.instance().nbtWriteToDisk();
                if (unloadInstances) {
                    PetsManager.instance().reset();
                }
            }
            PlayerQuestManager.i().saveData(false, unloadInstances);
            WorldDirectorManager.instance().writeToFile(unloadInstances);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void dbg(String obj) {
        CULog.dbg(obj);
    }

    static {
        initProperNeededForInstance = true;
        eventChannelName = modID;
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(eventChannelName);
        configCoroUtil = new ConfigCoroUtil();
        configDev = new ConfigCoroUtilAdvanced();
        configDD = new ConfigDynamicDifficulty();
        configHWMonsters = new ConfigHWMonsters();
        configBlockDestruction = new ConfigBlockDestruction();
    }
}

