/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.pathfinding;

import CoroUtil.ChunkCoordinatesSize;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.pathfinding.IPFCallback;
import CoroUtil.pathfinding.PFJobData;
import CoroUtil.pathfinding.PathEx;
import CoroUtil.pathfinding.PathPointEx;
import CoroUtil.pathfinding.c_IEnhPF;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.DimensionChunkCacheNew;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PFQueue
implements Runnable {
    public static PFQueue instance;
    public static LinkedList<PFJobData> queue;
    public static HashMap pfDelays;
    public static boolean renderLine;
    public static long maxRequestAge;
    public static long maxNodeIterations;
    public IBlockAccess worldMap;
    private PathEx path = new PathEx();
    private IntHashMap pointMap = new IntHashMap();
    private PathPointEx[] pathOptions = new PathPointEx[32];
    public boolean foundEnd;
    public boolean canClimb = false;
    public int maxClimbHeight = 30;
    public boolean canUseLadder = true;
    public long dropSize = 4L;
    public EntityCreature entH = null;
    public static int lastQueueSize;
    public static long lastSuccessPFTime;
    public static int lastChunkCacheCount;
    public long statsPerSecondLastReset = 0L;
    public int statsPerSecondPathSoFar = 0;
    public int statsPerSecondPathSkippedSoFar = 0;
    public int statsPerSecondNodeSoFar = 0;
    public int statsPerSecondNodeMaxIterSoFar = 0;
    public static int statsPerSecondPath;
    public static int statsPerSecondPathSkipped;
    public static int statsPerSecondNode;
    public static int statsPerSecondNodeMaxIter;
    public static int pfDelayScale;
    public static int pfDelayMax;
    public static boolean debug;
    public static long lastCacheUpdate;

    public PFQueue(IBlockAccess var1) {
        this(var1, true);
    }

    public PFQueue(IBlockAccess var1, boolean singleton) {
        if (instance == null && singleton) {
            instance = this;
            queue = new LinkedList();
            pfDelays = new HashMap();
        }
        if (var1 != null) {
            this.worldMap = var1;
        }
    }

    @Override
    public void run() {
        while (this == instance) {
            try {
                this.manageQueue();
            }
            catch (Exception ex) {
                if (ConfigCoroUtilAdvanced.PFQueueDebug) {
                    System.out.println("Serious PFQueue crash, reinitializing");
                }
                instance = null;
            }
        }
        System.out.println("Old PFQueue thread end");
    }

    public void manageQueue() {
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean getPath(Entity var1, Entity var2, float var3) {
        return PFQueue.getPath(var1, var2, var3, 0);
    }

    public static boolean getPath(Entity var1, Entity var2, float var3, int priority) {
        return PFQueue.getPath(var1, var2, var3, priority, null);
    }

    public static boolean getPath(Entity var1, Entity var2, float var3, int priority, IPFCallback parCallback) {
        if (var1 != null && var2 != null) {
            return PFQueue.tryPath(var1, (int)Math.floor(var2.field_70165_t), (int)Math.floor(var2.func_174813_aQ().field_72338_b + 0.5), (int)Math.floor(var2.field_70161_v), var3, priority, parCallback);
        }
        return false;
    }

    public static boolean getPath(Entity var1, int x, int y, int z, float var2) {
        return PFQueue.getPath(var1, x, y, z, var2, 0);
    }

    public static boolean getPath(Entity var1, int x, int y, int z, float var2, int priority) {
        return PFQueue.getPath(var1, x, y, z, var2, priority, null);
    }

    public static boolean getPath(Entity var1, int x, int y, int z, float var2, int priority, IPFCallback parCallback) {
        return PFQueue.tryPath(var1, x, y, z, var2, priority, parCallback);
    }

    public static boolean getPath(ChunkCoordinatesSize coordSize, int x, int y, int z, float var2, int priority, IPFCallback parCallback) {
        return PFQueue.tryPath(null, x, y, z, var2, priority, parCallback, coordSize);
    }

    public static boolean tryPath(Entity var1, int x, int y, int z, float var2, int priority, IPFCallback parCallback) {
        return PFQueue.tryPath(var1, x, y, z, var2, priority, parCallback, null);
    }

    public static boolean tryPath(PFJobData parJob) {
        parJob.initData();
        if (instance == null) {
            new PFQueue(null);
        }
        if (lastCacheUpdate < System.currentTimeMillis()) {
            lastCacheUpdate = System.currentTimeMillis() + 10000L;
            DimensionChunkCacheNew.updateAllWorldCache();
        }
        int delay = 3000 + queue.size() * 20;
        boolean tryPath = true;
        if (parJob.sourceEntity != null) {
            Entity var1 = parJob.sourceEntity;
            if (pfDelays.containsKey(var1)) {
                Object obj = pfDelays.get(var1);
                long time = 0L;
                if (obj != null) {
                    time = (Long)obj;
                }
                if (time < System.currentTimeMillis()) {
                    pfDelays.put(var1, System.currentTimeMillis() + (long)delay);
                } else {
                    tryPath = false;
                }
            } else {
                pfDelays.put(var1, System.currentTimeMillis() + (long)delay);
            }
        }
        if (tryPath || parJob.priority == -1) {
            try {
                if (parJob.priority == 0) {
                    queue.addLast(parJob);
                } else if (parJob.priority == -1) {
                    queue.addFirst(parJob);
                } else {
                    int pos = 0;
                    while (queue.size() > 0 && parJob.priority < PFQueue.queue.get((int)pos++).priority) {
                    }
                    queue.add(pos, parJob);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static boolean tryPath(Entity var1, int x, int y, int z, float var2, int priority, IPFCallback parCallback, ChunkCoordinatesSize parCoordSize) {
        if (var1 != null && CoroUtilBlock.isAir(var1.field_70170_p.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c())) {
            while (CoroUtilBlock.isAir(var1.field_70170_p.func_180495_p(new BlockPos(x, --y, z)).func_177230_c()) && y > 0) {
                --y;
            }
        }
        if (instance == null) {
            if (var1 == null) {
                return false;
            }
            new PFQueue(null);
        }
        if (lastCacheUpdate < System.currentTimeMillis()) {
            lastCacheUpdate = System.currentTimeMillis() + 10000L;
            DimensionChunkCacheNew.updateAllWorldCache();
        }
        int delay = 3000 + queue.size() * 20;
        boolean tryPath = true;
        if (pfDelays.containsKey(var1)) {
            Object obj = pfDelays.get(var1);
            long time = 0L;
            if (obj != null) {
                time = (Long)obj;
            }
            if (time < System.currentTimeMillis()) {
                pfDelays.put(var1, System.currentTimeMillis() + (long)delay);
            } else {
                tryPath = false;
            }
        } else {
            pfDelays.put(var1, System.currentTimeMillis() + (long)delay);
        }
        if (tryPath || priority == -1) {
            if (priority == -1) {
                boolean obj = false;
            }
            PFJobData job = null;
            if (var1 != null) {
                job = new PFJobData(var1, x, y, z, var2);
                job.callback = parCallback;
                job.canUseLadder = true;
            } else if (parCoordSize != null) {
                job = new PFJobData(parCoordSize, x, y, z, var2);
                job.callback = parCallback;
                job.canUseLadder = true;
            } else {
                System.out.println("invalid use of PFQueue");
            }
            try {
                if (priority == 0) {
                    queue.addLast(job);
                } else if (priority == -1) {
                    queue.addFirst(job);
                } else {
                    int pos = 0;
                    while (queue.size() > 0 && priority < PFQueue.queue.get((int)pos++).priority) {
                    }
                    queue.add(pos, job);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (var1 != null) {
                // empty if block
            }
            if (var1 instanceof c_IEnhPF) {
                c_IEnhPF c_IEnhPF2 = (c_IEnhPF)var1;
            } else if (var1 instanceof EntityLiving) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public void dbg(Object obj) {
        if (debug) {
            System.out.println(obj);
        }
    }

    public static boolean isFenceLike(Block block) {
        return block instanceof BlockFence || block == Blocks.field_150463_bK;
    }

    public static boolean isPressurePlate(Block block) {
        return block == Blocks.field_150445_bS || block == Blocks.field_150443_bT || block == Blocks.field_150456_au || block == Blocks.field_150452_aw;
    }

    public static boolean isNotPathable(Block block) {
        return block == Blocks.field_150381_bn;
    }

    static {
        pfDelays = new HashMap();
        renderLine = true;
        maxRequestAge = 8000L;
        maxNodeIterations = 15000L;
        lastQueueSize = 0;
        lastSuccessPFTime = 0L;
        lastChunkCacheCount = 0;
        statsPerSecondPath = 0;
        statsPerSecondPathSkipped = 0;
        statsPerSecondNode = 0;
        statsPerSecondNodeMaxIter = 0;
        pfDelayScale = 5;
        pfDelayMax = 500;
        debug = true;
        lastCacheUpdate = 0L;
    }
}

