/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.util.Vec3;
import java.util.List;

public class CoroUtilPhysics {
    public static boolean isInConvexShape(Vec3 test, List<Vec3> points) {
        boolean result = false;
        int i = 0;
        int j = points.size() - 1;
        while (i < points.size()) {
            Vec3 vecI = points.get(i);
            Vec3 vecJ = points.get(j);
            if (vecI.zCoord > test.zCoord != vecJ.zCoord > test.zCoord && test.xCoord < (vecJ.xCoord - vecI.xCoord) * (test.zCoord - vecI.zCoord) / (vecJ.zCoord - vecI.zCoord) + vecI.xCoord) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public static double getDistanceToShape(Vec3 point, List<Vec3> points) {
        float closestDist1 = 9999.0f;
        float closestDist2 = 9999.0f;
        Vec3 closestPoint1 = null;
        Vec3 closestPoint2 = null;
        for (int i = 0; i < 2; ++i) {
            for (Vec3 pointTest : points) {
                double dist = pointTest.distanceTo(point);
                if (dist < (double)closestDist1) {
                    closestDist1 = (float)dist;
                    closestPoint1 = pointTest;
                    continue;
                }
                if (!(dist < (double)closestDist2) || pointTest == closestPoint1) continue;
                closestDist2 = (float)dist;
                closestPoint2 = pointTest;
            }
        }
        if (closestPoint1 == null || closestPoint2 == null) {
            return -1.0;
        }
        return CoroUtilPhysics.distBetweenPointAndLine(point.xCoord, point.zCoord, closestPoint1.xCoord, closestPoint1.zCoord, closestPoint2.xCoord, closestPoint2.zCoord);
    }

    public static double distBetweenPointAndLine(double x, double y, double x1, double y1, double x2, double y2) {
        double AB = CoroUtilPhysics.distBetween(x, y, x1, y1);
        double BC = CoroUtilPhysics.distBetween(x1, y1, x2, y2);
        double AC = CoroUtilPhysics.distBetween(x, y, x2, y2);
        double s = (AB + BC + AC) / 2.0;
        double area = Math.sqrt(s * (s - AB) * (s - BC) * (s - AC));
        double AD = 2.0 * area / BC;
        return AD;
    }

    public static double distBetween(double x, double y, double x1, double y1) {
        double xx = x1 - x;
        double yy = y1 - y;
        return Math.sqrt(xx * xx + yy * yy);
    }
}

