/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.entity;

import extendedrenderer.particle.entity.ParticleTexFX;
import extendedrenderer.shader.InstancedMeshParticle;
import extendedrenderer.shader.Matrix4fe;
import extendedrenderer.shader.Transformation;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class ParticleCustomMatrix
extends ParticleTexFX {
    public float angleX;
    public float angleY;
    public float angleZ;
    public float yy;

    public ParticleCustomMatrix(World worldIn, double posXIn, double posYIn, double posZIn, double mX, double mY, double mZ, TextureAtlasSprite par8Item) {
        super(worldIn, posXIn, posYIn, posZIn, mX, mY, mZ, par8Item);
    }

    @Override
    public void renderParticleForShader(InstancedMeshParticle mesh, Transformation transformation, Matrix4fe viewMatrix, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (mesh.curBufferPos >= mesh.numInstances) {
            return;
        }
        float posX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float posY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float posZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        Vector3f pos = new Vector3f(posX, posY, posZ);
        Matrix4fe matrixFunnel = new Matrix4fe();
        matrixFunnel.rotateY(this.angleY);
        matrixFunnel.rotateX(this.angleX);
        matrixFunnel.translate(new Vector3f(0.0f, this.yy, 0.0f));
        if (this.rotationAroundCenter < this.rotationAroundCenterPrev) {
            this.rotationAroundCenterPrev -= 360.0f;
        }
        float deltaRot = this.rotationAroundCenterPrev + (this.rotationAroundCenter - this.rotationAroundCenterPrev) * partialTicks;
        matrixFunnel.translate(new Vector3f((float)Math.sin(Math.toRadians(deltaRot)) * this.rotationDistAroundCenter, 0.0f, (float)Math.cos(Math.toRadians(deltaRot)) * this.rotationDistAroundCenter));
        Vector3f posExtraRot = matrixFunnel.getTranslation();
        pos.x += posExtraRot.x;
        pos.y += posExtraRot.y;
        pos.z += posExtraRot.z;
        Matrix4fe modelMatrix = transformation.buildModelMatrix(this, pos, partialTicks);
        modelMatrix.get(21 * mesh.curBufferPos, mesh.instanceDataBuffer);
        float brightness = this.brightnessCache;
        mesh.instanceDataBuffer.put(21 * mesh.curBufferPos + 16, brightness);
        int rgbaIndex = 0;
        mesh.instanceDataBuffer.put(21 * mesh.curBufferPos + 16 + 1 + rgbaIndex++, this.func_70534_d());
        mesh.instanceDataBuffer.put(21 * mesh.curBufferPos + 16 + 1 + rgbaIndex++, this.func_70542_f());
        mesh.instanceDataBuffer.put(21 * mesh.curBufferPos + 16 + 1 + rgbaIndex++, this.func_70535_g());
        mesh.instanceDataBuffer.put(21 * mesh.curBufferPos + 16 + 1 + rgbaIndex++, this.getAlphaF());
        ++mesh.curBufferPos;
    }

    public static float lerpDegrees(float start, float end, float amount) {
        float difference = Math.abs(end - start);
        if (difference > 180.0f) {
            if (end > start) {
                start += 360.0f;
            } else {
                end += 360.0f;
            }
        }
        float value = start + (end - start) * amount;
        float rangeZero = 360.0f;
        if (value >= 0.0f && value <= 360.0f) {
            return value;
        }
        return value % rangeZero;
    }
}

