/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.shader;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class MeshColored {
    private int vaoId;
    private int posVboId;
    private int colourVboId;
    private int idxVboId;
    private int vertexCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeshColored(float[] positions, float[] colours, int[] indices) {
        this.vertexCount = indices.length;
        FloatBuffer verticesBuffer = null;
        IntBuffer indicesBuffer = null;
        FloatBuffer colourBuffer = null;
        try {
            verticesBuffer = BufferUtils.createFloatBuffer((int)positions.length);
            verticesBuffer.put(positions).flip();
            this.vaoId = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)this.vaoId);
            this.posVboId = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)this.posVboId);
            GL15.glBufferData((int)34962, (FloatBuffer)verticesBuffer, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
            GL20.glEnableVertexAttribArray((int)0);
            this.colourVboId = GL15.glGenBuffers();
            colourBuffer = BufferUtils.createFloatBuffer((int)colours.length);
            colourBuffer.put(colours).flip();
            GL15.glBindBuffer((int)34962, (int)this.colourVboId);
            GL15.glBufferData((int)34962, (FloatBuffer)colourBuffer, (int)35044);
            GL20.glVertexAttribPointer((int)1, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
            this.idxVboId = GL15.glGenBuffers();
            indicesBuffer = BufferUtils.createIntBuffer((int)indices.length);
            indicesBuffer.put(indices).flip();
            GL15.glBindBuffer((int)34963, (int)this.idxVboId);
            GL15.glBufferData((int)34963, (IntBuffer)indicesBuffer, (int)35044);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
        }
        finally {
            if (verticesBuffer != null) {
                // empty if block
            }
        }
    }

    public void render() {
        GL30.glBindVertexArray((int)this.getVaoId());
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL11.glDrawElements((int)4, (int)this.getVertexCount(), (int)5125, (long)0L);
        GL20.glDisableVertexAttribArray((int)0);
        GL20.glDisableVertexAttribArray((int)1);
        GL30.glBindVertexArray((int)0);
    }

    public int getColourVboId() {
        return this.colourVboId;
    }

    public void setColourVboId(int colourVboId) {
        this.colourVboId = colourVboId;
    }

    public int getIdxVboId() {
        return this.idxVboId;
    }

    public void setIdxVboId(int idxVboId) {
        this.idxVboId = idxVboId;
    }

    public int getVaoId() {
        return this.vaoId;
    }

    public void setVaoId(int vaoId) {
        this.vaoId = vaoId;
    }

    public int getPosVboId() {
        return this.posVboId;
    }

    public void setPosVboId(int posVboId) {
        this.posVboId = posVboId;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public void setVertexCount(int vertexCount) {
        this.vertexCount = vertexCount;
    }

    public void cleanup() {
        GL20.glDisableVertexAttribArray((int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glDeleteBuffers((int)this.posVboId);
        GL15.glDeleteBuffers((int)this.colourVboId);
        GL15.glDeleteBuffers((int)this.idxVboId);
        GL30.glBindVertexArray((int)0);
        GL30.glDeleteVertexArrays((int)this.vaoId);
    }
}

