/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import com.creativemd.creativecore.common.config.api.CreativeConfig;
import com.creativemd.creativecore.common.config.premade.IntMinMax;
import com.creativemd.creativecore.common.config.premade.curve.Curve;
import com.creativemd.creativecore.common.config.premade.curve.DecimalCurve;
import com.creativemd.creativecore.common.config.premade.curve.IntCurve;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.event.VisualExplosionEvent;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeBlur;
import team.creative.enhancedvisuals.api.type.VisualTypeParticle;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.client.sound.SoundMuteHandler;

public class ExplosionHandler
extends VisualHandler {
    @CreativeConfig
    public VisualType dust = new VisualTypeParticle("dust");
    @CreativeConfig
    public IntMinMax dustDuration = new IntMinMax(500, 1000);
    @CreativeConfig
    public IntCurve dustAmount = new IntCurve(0, 0, 20, 30);
    @CreativeConfig
    public float maxExplosionVolume = 0.5f;
    @CreativeConfig
    public IntCurve explosionSoundTime = new IntCurve(0, 50, 20, 200);
    @CreativeConfig
    public VisualType blur = new VisualTypeBlur("blur");
    @CreativeConfig
    public DecimalCurve maxBlur = new DecimalCurve(0.0, 50.0, 10.0, 100.0);
    @CreativeConfig
    public IntCurve explosionBlurTime = new IntCurve(0, 10, 20, 20);

    public void onExploded(EntityPlayer player, Vec3d pos, float size, @Nullable Entity source) {
        float f3 = size * 2.0f;
        double d12 = player.func_70011_f(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c) / (double)f3;
        double d14 = ExplosionHandler.getBlockDensity(pos, (Entity)player);
        double d10 = (1.0 - d12) * d14;
        float damage = (int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0);
        VisualExplosionEvent event = new VisualExplosionEvent(damage);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled() && event.getNewDamage() > 0.0f) {
            damage = event.getNewDamage();
            VisualManager.addParticlesFadeOut(this.dust, (VisualHandler)this, (int)this.dustAmount.valueAt((double)damage), this.dustDuration, true);
            DecimalCurve explosionSoundVolume = new DecimalCurve(0.0, (double)this.maxExplosionVolume, this.explosionSoundTime.valueAt((double)damage), 0.0);
            DecimalCurve explosionSoundMuteVolume = new DecimalCurve(0.0, 1.0, this.explosionSoundTime.valueAt((double)damage), 0.0);
            if (SoundMuteHandler.startMuting(explosionSoundMuteVolume)) {
                this.playSoundFadeOut(new ResourceLocation("enhancedvisuals", "ringing"), null, explosionSoundVolume);
            }
            if (!event.isBlurDisabled()) {
                VisualManager.addVisualFadeOut(this.blur, (VisualHandler)this, (Curve)new DecimalCurve(0.0, this.maxBlur.valueAt((double)damage), (double)((int)this.explosionBlurTime.valueAt((double)damage)), 0.0));
            }
        }
    }

    public static double lerp(double pct, double start, double end) {
        return start + pct * (end - start);
    }

    public static float getBlockDensity(Vec3d p_222259_0_, Entity p_222259_1_) {
        AxisAlignedBB axisalignedbb = p_222259_1_.func_174813_aQ();
        double d0 = 1.0 / ((axisalignedbb.field_72336_d - axisalignedbb.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.field_72337_e - axisalignedbb.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.field_72334_f - axisalignedbb.field_72339_c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d7;
                        double d6;
                        double d5 = ExplosionHandler.lerp(f, axisalignedbb.field_72340_a, axisalignedbb.field_72336_d);
                        Vec3d vec3d = new Vec3d(d5 + d3, d6 = ExplosionHandler.lerp(f1, axisalignedbb.field_72338_b, axisalignedbb.field_72337_e), (d7 = ExplosionHandler.lerp(f2, axisalignedbb.field_72339_c, axisalignedbb.field_72334_f)) + d4);
                        RayTraceResult result = p_222259_1_.field_70170_p.func_72933_a(vec3d, p_222259_0_);
                        if (result == null || result.field_72313_a == RayTraceResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }
}

