/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.Vec3d;

public class Waypoint
implements Comparable<Waypoint> {
    public static final int ONEOFF_DESTINATION_SAFE_FOR = 5000;
    public static final int ONEOFF_DESTINATION_REMOVE_DISTANCE = 4;
    private int x;
    private int y;
    private int z;
    private String name;
    private String symbol;
    private int color;
    private boolean global;
    private boolean disabled = false;
    private int type = 0;
    private boolean rotation = false;
    private int yaw = 0;
    private boolean temporary;
    private boolean yIncluded;
    public static Vec3d RENDER_SORTING_POS;
    private final long createdAt;
    private boolean oneoffDestination;

    public Waypoint(int x, int y, int z, String name, String symbol, int color) {
        this(x, y, z, name, symbol, color, 0, false);
    }

    public Waypoint(int x, int y, int z, String name, String symbol, int color, int type) {
        this(x, y, z, name, symbol, color, type, false);
    }

    public Waypoint(int x, int y, int z, String name, String symbol, int color, int type, boolean temp) {
        this(x, y, z, name, symbol, color, type, temp, true);
    }

    public Waypoint(int x, int y, int z, String name, String symbol, int color, int type, boolean temp, boolean yIncluded) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.name = name;
        this.temporary = temp;
        if (this.type == 1 || this.type == 2) {
            this.global = true;
            this.oneoffDestination = true;
        }
        this.yIncluded = yIncluded;
        this.createdAt = System.currentTimeMillis();
    }

    public double getDistanceSq(double x, double y, double z) {
        double d3 = (double)this.x - x;
        double d4 = (double)this.y - y;
        double d5 = (double)this.z - z;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean b) {
        this.temporary = false;
        this.disabled = b;
    }

    @Deprecated
    public int getType() {
        return this.type != 1 ? 0 : 1;
    }

    public int getWaypointType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        if (this.type == 1 || this.type == 2) {
            this.global = true;
            this.oneoffDestination = true;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getX(double dimDiv) {
        if (dimDiv == 1.0) {
            return this.x;
        }
        return (int)Math.floor((double)this.x / dimDiv);
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getZ(double dimDiv) {
        if (dimDiv == 1.0) {
            return this.z;
        }
        return (int)Math.floor((double)this.z / dimDiv);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String getName() {
        return this.name;
    }

    public String getNameSafe(String replacement) {
        return this.getName().replace(":", replacement);
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
        this.disabled = false;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbolSafe(String replacement) {
        return this.getSymbol().replace(":", replacement);
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
    }

    public int getColor() {
        if (this.color < 0) {
            return 0;
        }
        return this.color;
    }

    public int getActualColor() {
        return this.color;
    }

    public void setColor(int c) {
        this.color = c;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        if (this.type != 1) {
            this.global = global;
        }
    }

    public static String getStringFromStringSafe(String stringSafe, String replacement) {
        return stringSafe.replace(replacement, ":");
    }

    public boolean isServerWaypoint() {
        return false;
    }

    public String getComparisonName() {
        String comparisonName = this.getLocalizedName().toLowerCase().trim();
        if (comparisonName.startsWith("the ")) {
            comparisonName = comparisonName.substring(4);
        }
        if (comparisonName.startsWith("a ")) {
            comparisonName = comparisonName.substring(2);
        }
        return comparisonName;
    }

    public double getComparisonDistance(Vec3d cameraPos, double dimDiv) {
        double offX = (double)this.getX(dimDiv) - cameraPos.field_72450_a;
        double offY = !this.isYIncluded() ? 0.0 : (double)this.getY() - cameraPos.field_72448_b;
        double offZ = (double)this.getZ(dimDiv) - cameraPos.field_72449_c;
        return offX * offX + offY * offY + offZ * offZ;
    }

    public double getComparisonAngleCos(Vec3d cameraPos, Vec3d lookVector, double dimDiv) {
        double offX = (double)this.getX(dimDiv) - cameraPos.field_72450_a;
        double offY = !this.isYIncluded() ? 0.0 : (double)this.getY() - cameraPos.field_72448_b;
        double offZ = (double)this.getZ(dimDiv) - cameraPos.field_72449_c;
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        return (offX * lookVector.field_72450_a + offY * lookVector.field_72448_b + offZ * lookVector.field_72449_c) / distance;
    }

    private double getRenderSortingDistanceSquared() {
        double fromCameraX = (double)this.x - Waypoint.RENDER_SORTING_POS.field_72450_a;
        double fromCameraY = this.yIncluded ? (double)this.y - Waypoint.RENDER_SORTING_POS.field_72448_b : 0.0;
        double fromCameraZ = (double)this.z - Waypoint.RENDER_SORTING_POS.field_72449_c;
        return fromCameraX * fromCameraX + fromCameraY * fromCameraY + fromCameraZ * fromCameraZ;
    }

    @Override
    public int compareTo(Waypoint other) {
        double otherRsds;
        boolean isDeath = this.type == 1 || this.type == 2;
        if (isDeath != (other.type == 1 || other.type == 2)) {
            return isDeath ? 1 : -1;
        }
        double rsds = this.getRenderSortingDistanceSquared();
        return rsds > (otherRsds = other.getRenderSortingDistanceSquared()) ? -1 : (rsds == otherRsds ? 0 : 1);
    }

    public boolean isYIncluded() {
        return this.yIncluded;
    }

    public void setYIncluded(boolean yIncluded) {
        this.yIncluded = yIncluded;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean isOneoffDestination() {
        return this.oneoffDestination;
    }
}

