/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.settings.ModSettings;

public class CompassRenderer {
    private final IXaeroMinimap modMain;
    private final Minecraft mc;
    private double[] partialDest;

    public CompassRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
        this.mc = mc;
        this.partialDest = new double[2];
    }

    public void drawCompass(MinimapRendererHelper rendererHelper, int specW, int specH, double ps, double pc, double zoom, boolean circle, float minimapScale, boolean background) {
        if (this.modMain.getSettings().compassLocation == 0) {
            return;
        }
        String[] nesw = new String[]{I18n.func_135052_a((String)"gui.xaero_compass_north", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_east", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_south", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_west", (Object[])new Object[0])};
        int defaultColor = ModSettings.COLORS[this.modMain.getSettings().compassColor];
        for (int i = 0; i < 4; ++i) {
            int effectiveColor;
            double offx;
            double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
            double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
            GlStateManager.func_179094_E();
            MinimapElementOverMapRendererHandler.translatePosition(specW, specH, ps, pc, offx, offy, zoom, circle, this.partialDest);
            GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)minimapScale, (float)minimapScale, (float)1.0f);
            int halfW = this.mc.field_71466_p.func_78256_a(nesw[i]) / 2 - 1;
            int n = effectiveColor = i == 0 ? ModSettings.COLORS[this.modMain.getSettings().getNorthCompassColor()] : defaultColor;
            if (background) {
                GlStateManager.func_179090_x();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                int addedFrame = halfW > 3 ? halfW - 3 : 0;
                rendererHelper.drawMyColoredRect(-4 - addedFrame, -4 - addedFrame, 5 + addedFrame, 5 + addedFrame, 0x90000000 | effectiveColor & 0xFFFFFF);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179098_w();
            }
            Minecraft.func_71410_x().field_71466_p.func_78276_b(nesw[i], -halfW + 1, -2, effectiveColor);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(nesw[i], -halfW, -3, -1);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
    }
}

