/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.former;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockSurfaceArea;
import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.world.MockWorld;
import ivorius.reccomplex.block.BlockGenericSpace;
import ivorius.reccomplex.block.RCBlocks;
import ivorius.reccomplex.commands.CommandVirtual;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.NaP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class CommandNaturalFloor
extends CommandExpecting
implements CommandVirtual {
    public static void placeNaturalFloor(MockWorld world, BlockArea area, double lowerExpansion) {
        lowerExpansion += 0.01;
        IBlockState floorBlock = RCBlocks.genericSolid.func_176223_P();
        BlockGenericSpace airBlock1 = RCBlocks.genericSpace;
        BlockPos lowerPoint = area.getLowerCorner();
        BlockPos higherPoint = area.getHigherCorner();
        HashSet<BlockSurfacePos> stopped = new HashSet<BlockSurfacePos>();
        HashSet<BlockSurfacePos> stopping = new HashSet<BlockSurfacePos>();
        for (int y = lowerPoint.func_177956_o() + 1; y <= higherPoint.func_177956_o(); ++y) {
            for (BlockSurfacePos surfaceCoord : BlockSurfaceArea.from(area).stream().filter(o -> !stopped.contains(o))::iterator) {
                IBlockState block = world.func_180495_p(surfaceCoord.blockPos(y));
                if (block.func_185904_a() == Material.field_151579_a || block.func_177230_c() == airBlock1) continue;
                stopping.add(surfaceCoord);
                if (block == floorBlock || !block.func_185904_a().func_76218_k()) continue;
                CommandNaturalFloor.setBlockIfAirInArea(world, surfaceCoord.blockPos(y - 1), floorBlock, area);
                CommandNaturalFloor.fillSurface(world, area, lowerExpansion, floorBlock, surfaceCoord.blockPos(y), stopping);
            }
            stopped.addAll(stopping);
            stopping.clear();
        }
    }

    private static void fillSurface(MockWorld world, BlockArea area, double expansion, IBlockState floorBlock, BlockPos pos, Set<BlockSurfacePos> coords) {
        BlockSurfacePos surfacePos = BlockSurfacePos.from(pos);
        int expX = MathHelper.func_76143_f((double)(-expansion));
        while ((double)expX <= expansion) {
            int expZ = MathHelper.func_76143_f((double)(-expansion));
            while ((double)expZ <= expansion) {
                if ((double)(expX * expX + expZ * expZ) <= expansion * expansion) {
                    BlockSurfacePos scoord = surfacePos.add(expX, expZ);
                    CommandNaturalFloor.setBlockIfAirInArea(world, scoord.blockPos(pos.func_177956_o()), floorBlock, area);
                    coords.add(scoord);
                }
                ++expZ;
            }
            ++expX;
        }
    }

    public static void setBlockIfAirInArea(MockWorld world, BlockPos coord, IBlockState block, BlockArea area) {
        IBlockState prevBlock;
        if (area.contains(coord) && ((prevBlock = world.func_180495_p(coord)).func_185904_a() == Material.field_151579_a || prevBlock.func_177230_c() == RCBlocks.genericSpace)) {
            world.setBlockState(coord, block);
        }
    }

    public String func_71517_b() {
        return "floor";
    }

    @Override
    public void expect(Expect expect) {
        expect.named("expansion", "e").any("0", "1", "2");
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void execute(MockWorld world, ICommandSender sender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        BlockArea area = RCCommands.getSelectionOwner(sender, null, true).getSelection();
        double expandFloor = parameters.get("expansion").to(NaP::asDouble).optional().orElse(1.0);
        CommandNaturalFloor.placeNaturalFloor(world, area, expandFloor);
    }
}

