/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.item;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.item.IvItemStacks;
import ivorius.reccomplex.gui.loot.GuiEditItemStack;
import ivorius.reccomplex.gui.loot.TableDataSourceLootGenMultiTag;
import ivorius.reccomplex.item.ItemLootGenerationTag;
import ivorius.reccomplex.item.ItemSyncableTags;
import ivorius.reccomplex.world.storage.loot.LootTable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class ItemLootGenMultiTag
extends ItemLootGenerationTag
implements ItemSyncableTags {
    public static TIntList emptySlots(IItemHandler inv) {
        TIntArrayList list = new TIntArrayList();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i) != ItemStack.field_190927_a) continue;
            list.add(i);
        }
        return list;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            this.openGui(playerIn, playerIn.field_71071_by.field_70461_c);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(EntityPlayer player, int slot) {
        Minecraft.func_71410_x().func_147108_a(new GuiEditItemStack<TableDataSourceLootGenMultiTag>(player, slot, new TableDataSourceLootGenMultiTag()));
    }

    @Override
    public void generateInInventory(WorldServer server, IItemHandlerModifiable inventory, Random random, ItemStack stack, int fromSlot) {
        LootTable lootTable = ItemLootGenMultiTag.lootTable(stack);
        inventory.setStackInSlot(fromSlot, ItemStack.field_190927_a);
        if (lootTable != null) {
            IntegerRange range = this.getGenerationCount(stack);
            int amount = range.getMin() < range.getMax() ? random.nextInt(range.getMax() - range.getMin() + 1) + range.getMin() : 0;
            TIntList emptySlots = ItemLootGenMultiTag.emptySlots((IItemHandler)inventory);
            for (int i = 0; i < amount; ++i) {
                int slot = emptySlots.isEmpty() ? random.nextInt(inventory.getSlots()) : emptySlots.removeAt(random.nextInt(emptySlots.size()));
                ItemStack generated = lootTable.getRandomItemStack(server, random);
                if (generated == null) continue;
                inventory.setStackInSlot(slot, generated);
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IntegerRange range = this.getGenerationCount(stack);
        tooltip.add(String.format("%d - %d Items", range.getMin(), range.getMax()));
    }

    public IntegerRange getGenerationCount(ItemStack stack) {
        return new IntegerRange(IvItemStacks.getNBT(stack, "itemCountMin", 4), IvItemStacks.getNBT(stack, "itemCountMax", 8));
    }

    public void setGenerationCount(ItemStack stack, IntegerRange range) {
        stack.func_77983_a("itemCountMin", (NBTBase)new NBTTagInt(range.getMin()));
        stack.func_77983_a("itemCountMax", (NBTBase)new NBTTagInt(range.getMax()));
    }

    @Override
    public List<Pair<String, Integer>> getSyncedNBTTags() {
        return Arrays.asList(Pair.of((Object)"itemCountMin", (Object)3), Pair.of((Object)"itemCountMax", (Object)3));
    }
}

