/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.operation;

import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.operation.OperationRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class OperationMulti
implements Operation {
    public final List<Operation> operations = new ArrayList<Operation>();

    public OperationMulti() {
    }

    public OperationMulti(List<Operation> operations) {
        this.operations.addAll(operations);
    }

    public OperationMulti(Operation ... operations) {
        Collections.addAll(this.operations, operations);
    }

    @Override
    public void perform(WorldServer world) {
        this.operations.forEach(o -> o.perform(world));
    }

    @Override
    public void update(World world, int ticks) {
        this.operations.forEach(o -> o.update(world, ticks));
    }

    @Override
    public boolean checkDead(ICommandSender target) {
        return this.operations.stream().anyMatch(o -> o.checkDead(target));
    }

    @Override
    public void renderPreview(Operation.PreviewType previewType, World world, int ticks, float partialTicks) {
        for (int i = this.operations.size() - 1; i >= 0; --i) {
            this.operations.get(i).renderPreview(previewType, world, ticks, partialTicks);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.operations.clear();
        NBTTagLists.compoundsFrom(compound, "operations").stream().map(OperationRegistry::readOperation).forEach(this.operations::add);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagLists.writeTo(compound, "operations", this.operations.stream().map(OperationRegistry::writeOperation).collect(Collectors.toList()));
    }
}

