/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.sapling;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.util.IvFunctions;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.sapling.VanillaSaplingPredictor;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.SaplingGeneration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import org.apache.commons.lang3.tuple.Pair;

public class RCSaplingGenerator {
    public static final List<Predictor> predictors = new ArrayList<Predictor>();

    public static boolean maybeGrowSapling(WorldServer world, BlockPos pos, Random random) {
        if (RCConfig.saplingTriggerChance <= 0.0 || RCConfig.saplingTriggerChance < 1.0 && (double)random.nextFloat() < RCConfig.saplingTriggerChance) {
            return false;
        }
        Pair<Structure<?>, SaplingGeneration> pair = RCSaplingGenerator.findRandomSapling(world, pos, random, true);
        if (pair == null) {
            return false;
        }
        RCSaplingGenerator.growSapling(world, pos, random, (Structure)pair.getLeft(), (SaplingGeneration)pair.getRight());
        return true;
    }

    @Nullable
    public static Pair<Structure<?>, SaplingGeneration> findRandomSapling(WorldServer world, BlockPos pos, Random random, boolean considerVanilla) {
        Environment baseEnv = Environment.inNature(world, new StructureBoundingBox((Vec3i)pos, (Vec3i)pos));
        List applicable = StructureRegistry.INSTANCE.getGenerationTypes(SaplingGeneration.class).stream().filter(pair1 -> ((SaplingGeneration)pair1.getRight()).generatesIn(baseEnv.withGeneration((GenerationType)pair1.getRight()))).collect(Collectors.toCollection(ArrayList::new));
        int vanillaComplexity = RCSaplingGenerator.complexity(world, pos, random, predictors);
        ImmutableMultimap<Integer, Pair> groups2 = IvFunctions.groupMap(applicable, pair -> ((SaplingGeneration)pair.getRight()).pattern.pattern.compile(true).size());
        ArrayList complexities = Lists.newArrayList((Iterable)groups2.keySet());
        if (vanillaComplexity > 0) {
            complexities.add(vanillaComplexity);
        }
        Collections.sort(complexities);
        Pair pair2 = null;
        while (complexities.size() > 0 && pair2 == null) {
            Integer complexity = (Integer)complexities.remove(complexities.size() - 1);
            Set placeable = groups2.get((Object)complexity).stream().filter(p -> ((SaplingGeneration)p.getRight()).pattern.canPlace((World)world, pos, ((Structure)p.getLeft()).size(), ((Structure)p.getLeft()).isRotatable(), ((Structure)p.getLeft()).isMirrorable())).collect(Collectors.toSet());
            double totalWeight = placeable.stream().mapToDouble(RCSaplingGenerator::getSpawnWeight).sum();
            if (complexity == vanillaComplexity && considerVanilla && random.nextDouble() * (totalWeight * RCConfig.baseSaplingSpawnWeight + 1.0) < 1.0) break;
            if (!(totalWeight > 0.0)) continue;
            pair2 = WeightedSelector.select(random, placeable, RCSaplingGenerator::getSpawnWeight);
        }
        return pair2;
    }

    public static int complexity(WorldServer world, BlockPos pos, Random random, List<Predictor> predictors) {
        return predictors.stream().mapToInt(a -> a.complexity((World)world, pos, world.func_180495_p(pos), random)).filter(i -> i >= 0).max().orElse(-1);
    }

    public static double getSpawnWeight(Pair<Structure<?>, SaplingGeneration> p) {
        return (double)RCConfig.tweakedSpawnRate(StructureRegistry.INSTANCE.id(p.getLeft())) * ((SaplingGeneration)p.getRight()).getActiveWeight();
    }

    public static void growSapling(WorldServer world, BlockPos pos, Random random, Structure<?> structure, SaplingGeneration saplingGenInfo) {
        int[] strucSize = structure.size();
        Multimap<AxisAlignedTransform2D, BlockPos> placeables = saplingGenInfo.pattern.testAll((World)world, pos, strucSize, structure.isRotatable(), structure.isMirrorable());
        AxisAlignedTransform2D transform = (AxisAlignedTransform2D)Lists.newArrayList((Iterable)placeables.keys()).get(random.nextInt(placeables.keys().size()));
        Collection transformedPositions = placeables.get((Object)transform);
        BlockPos startPos = (BlockPos)Lists.newArrayList((Iterable)transformedPositions).get(random.nextInt(transformedPositions.size()));
        HashMap<BlockPos, IBlockState> before = new HashMap<BlockPos, IBlockState>();
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        saplingGenInfo.pattern.copy(transform, strucSize).forEach(i -> i.delete, (p, i) -> {
            BlockPos ePos = p.func_177971_a((Vec3i)startPos);
            before.put(ePos, world.func_180495_p(ePos));
            world.func_180501_a(ePos, air, 4);
        });
        BlockPos spawnPos = transform.apply(saplingGenInfo.spawnShift, new int[]{1, 1, 1}).func_177971_a((Vec3i)startPos);
        boolean success = new StructureGenerator(structure).world(world).generationInfo(saplingGenInfo).transform(transform).seed(random.nextLong()).maturity(StructureSpawnContext.GenerateMaturity.SUGGEST).memorize(RCConfig.memorizeSaplings).allowOverlaps(true).randomPosition(BlockSurfacePos.from(spawnPos), (context, blockCollection) -> spawnPos.func_177956_o()).generate().succeeded();
        if (!success) {
            before.forEach((pos1, state) -> world.func_180501_a(pos1, state, 4));
        }
    }

    static {
        predictors.add(new VanillaSaplingPredictor());
    }

    static interface Predictor {
        public int complexity(World var1, BlockPos var2, IBlockState var3, Random var4);
    }
}

