/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.base.interfaces;

import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import com.wynprice.secretroomsmod.handler.ParticleHandler;
import com.wynprice.secretroomsmod.render.FakeBlockAccess;
import com.wynprice.secretroomsmod.render.RenderStateUnlistedProperty;
import com.wynprice.secretroomsmod.render.fakemodels.FakeBlockModel;
import com.wynprice.secretroomsmod.render.fakemodels.SecretBlockModel;
import com.wynprice.secretroomsmod.render.fakemodels.TrueSightModel;
import com.wynprice.secretroomsmod.tileentity.TileEntityInfomationHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.util.Random;

public interface ISecretBlock
extends ITileEntityProvider {
    public static final IUnlistedProperty<IBlockState> RENDER_PROPERTY = new RenderStateUnlistedProperty();
    public static final ArrayList<TileEntity> ALL_SECRET_TILE_ENTITIES = new ArrayList();

    default public IBlockState getState(IBlockAccess world, BlockPos pos) {
        return world.func_175625_s(pos) instanceof ISecretTileEntity ? ((ISecretTileEntity)world.func_175625_s(pos)).getMirrorState() : null;
    }

    default public void forceBlockState(World world, BlockPos tePos, IBlockState state) {
        if (world.func_175625_s(tePos) instanceof ISecretTileEntity) {
            ((ISecretTileEntity)world.func_175625_s(tePos)).setMirrorStateForcable(state);
        }
    }

    default public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityInfomationHolder();
    }

    @SideOnly(value=Side.CLIENT)
    default public FakeBlockModel phaseModel(FakeBlockModel model) {
        return model;
    }

    @SideOnly(value=Side.CLIENT)
    default public TrueSightModel phaseTrueModel(TrueSightModel model) {
        return model;
    }

    default public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (source.func_175625_s(pos) instanceof ISecretTileEntity && ((ISecretTileEntity)source.func_175625_s(pos)).getMirrorState() != null) {
            return ((ISecretTileEntity)source.func_175625_s(pos)).getMirrorState().func_185900_c(source, pos);
        }
        return Block.field_185505_j;
    }

    default public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.getState(world, pos).func_177230_c().canBeConnectedTo(world, pos, facing);
    }

    default public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return ISecretTileEntity.getMirrorState(worldIn, pos).func_193401_d(worldIn, pos, face);
    }

    default public float getBlockHardness(IBlockState blockState, World worldIn, BlockPos pos) {
        return ISecretTileEntity.getMirrorState(worldIn, pos).func_185887_b(worldIn, pos);
    }

    default public Material getMaterial(IBlockState state, Material material) {
        IBlockState blockstate = null;
        ArrayList<TileEntity> list = new ArrayList<TileEntity>(ALL_SECRET_TILE_ENTITIES);
        for (TileEntity tileentity : list) {
            if (tileentity.func_145831_w() == null || !tileentity.func_145831_w().func_175667_e(tileentity.func_174877_v()) || tileentity.func_145831_w().func_180495_p(tileentity.func_174877_v()) != state || !(tileentity instanceof ISecretTileEntity)) continue;
            blockstate = ISecretTileEntity.getMirrorState(tileentity.func_145831_w(), tileentity.func_174877_v());
        }
        return blockstate != null && !(blockstate.func_177230_c() instanceof ISecretBlock) && blockstate.func_185904_a() != Material.field_151586_h ? blockstate.func_185904_a() : material;
    }

    default public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ISecretTileEntity.getMirrorState(world, pos).isSideSolid(world, pos, side);
    }

    default public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        if (worldIn.func_175625_s(pos) instanceof ISecretTileEntity && ISecretTileEntity.getMirrorState(worldIn, pos) != null) {
            ISecretTileEntity.getMirrorState(worldIn, pos).func_185908_a(worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        } else {
            Blocks.field_150348_b.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        }
    }

    default public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        return world.func_175625_s(pos) instanceof ISecretTileEntity && ISecretTileEntity.getMirrorState(world, pos) != null ? ISecretTileEntity.getMirrorState(world, pos).func_177230_c().func_185467_w() : SoundType.field_185851_d;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        if (target.func_178782_a() != null && worldObj.func_175625_s(target.func_178782_a()) instanceof ISecretTileEntity && ((ISecretTileEntity)worldObj.func_175625_s(target.func_178782_a())).getMirrorState() != null) {
            int i = target.func_178782_a().func_177958_n();
            int j = target.func_178782_a().func_177956_o();
            int k = target.func_178782_a().func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = ((ISecretTileEntity)worldObj.func_175625_s(target.func_178782_a())).getMirrorState().func_185900_c((IBlockAccess)worldObj, target.func_178782_a());
            double d0 = (double)i + new Random().nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + new Random().nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + new Random().nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            if (target.field_178784_b == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            manager.func_78873_a(((ParticleDigging)new ParticleDigging.Factory().func_178902_a(0, worldObj, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)((ISecretTileEntity)worldObj.func_175625_s(target.func_178782_a())).getMirrorState())})).func_174846_a(target.func_178782_a()).func_70543_e(0.2f).func_70541_f(0.6f));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        if (ParticleHandler.BLOCKBRAKERENDERMAP.get(pos) != null) {
            IBlockState state = ParticleHandler.BLOCKBRAKERENDERMAP.get(pos);
            try {
                state = state.func_185899_b((IBlockAccess)world, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int i = 4;
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        manager.func_78873_a((Particle)((ParticleDigging)new ParticleDigging.Factory().func_178902_a(0, world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, new int[]{Block.func_176210_f((IBlockState)state)})).func_174846_a(pos));
                    }
                }
            }
        }
        return false;
    }

    default public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos, IBlockState superState) {
        if (superState instanceof IExtendedBlockState) {
            return ((IExtendedBlockState)superState).withProperty(RENDER_PROPERTY, null);
        }
        return superState;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        IBlockState renderState;
        if (state instanceof IExtendedBlockState && (renderState = (IBlockState)((IExtendedBlockState)state).getValue(RENDER_PROPERTY)) != null) {
            return renderState.func_177230_c().func_180664_k() == layer;
        }
        return layer == BlockRenderLayer.SOLID;
    }

    default public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState && world.func_175625_s(pos) instanceof ISecretTileEntity && ((ISecretTileEntity)world.func_175625_s(pos)).getMirrorState() != null) {
            IBlockState renderState = ((ISecretTileEntity)world.func_175625_s(pos)).getMirrorState();
            try {
                renderState = renderState.func_185899_b((IBlockAccess)new FakeBlockAccess(world), pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
            if (model instanceof SecretBlockModel) {
                ((SecretBlockModel)model).AO.set(Minecraft.func_71410_x().func_175602_ab().func_184389_a(renderState).func_177555_b());
            }
            state = ((IExtendedBlockState)state).withProperty(RENDER_PROPERTY, (Object)renderState);
        }
        return state;
    }
}

