/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.blocks;

import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SecretButton
extends BlockButton
implements ISecretBlock {
    private final boolean wooden;

    public SecretButton(boolean wooden) {
        super(wooden);
        this.wooden = wooden;
        this.func_149663_c("secret_" + (wooden ? "wooden" : "stone") + "_button");
        this.setRegistryName("secret_" + (wooden ? "wooden" : "stone") + "_button");
        this.func_149711_c(0.5f);
        this.field_149785_s = true;
    }

    public Material func_149688_o(IBlockState state) {
        return ISecretBlock.super.getMaterial(state, super.func_149688_o(state));
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return ISecretBlock.super.canBeConnectedTo(world, pos, facing);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.field_72995_K && this.wooden && !((Boolean)state.func_177229_b((IProperty)field_176584_b)).booleanValue()) {
            this.checkPressed(state, worldIn, pos);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return ISecretBlock.super.getBlockFaceShape(worldIn, state, pos, face);
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ISecretBlock.super.isSideSolid(base_state, world, pos, side);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ISecretBlock.super.getBlockHardness(blockState, worldIn, pos);
    }

    private void checkPressed(IBlockState state, World worldIn, BlockPos pos) {
        List list = new ArrayList();
        if (worldIn.func_175625_s(pos) instanceof ISecretTileEntity && ((ISecretTileEntity)worldIn.func_175625_s(pos)).getMirrorState() != null) {
            list = worldIn.func_72872_a(EntityArrow.class, ((ISecretTileEntity)worldIn.func_175625_s(pos)).getMirrorState().func_185900_c((IBlockAccess)worldIn, pos).func_186670_a(pos));
        }
        boolean flag = !list.isEmpty();
        boolean flag1 = (Boolean)state.func_177229_b((IProperty)field_176584_b);
        if (flag && !flag1) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)field_176584_b, (Comparable)Boolean.valueOf(true)));
            worldIn.func_175685_c(pos, (Block)this, false);
            worldIn.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176734_d()), (Block)this, false);
            worldIn.func_175704_b(pos, pos);
            this.func_185615_a(null, worldIn, pos);
        }
        if (!flag && flag1) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)field_176584_b, (Comparable)Boolean.valueOf(false)));
            worldIn.func_175685_c(pos, (Block)this, false);
            worldIn.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176734_d()), (Block)this, false);
            worldIn.func_175704_b(pos, pos);
            this.func_185617_b(worldIn, pos);
        }
        if (flag) {
            worldIn.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, this.func_149738_a(worldIn));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ISecretBlock.super.getBoundingBox(state, source, pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        ISecretBlock.super.addCollisionBoxToList(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        return ISecretBlock.super.getSoundType(state, world, pos, entity);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return ISecretBlock.super.addHitEffects(state, worldObj, target, manager);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return ISecretBlock.super.addDestroyEffects(world, pos, manager);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return ISecretBlock.super.canRenderInLayer(state, layer);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.getExtendedState(ISecretBlock.super.getExtendedState(state, world, pos), world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        Collection properties = super.func_180661_e().func_177623_d();
        return new ExtendedBlockState((Block)this, properties.toArray(new IProperty[properties.size()]), new IUnlistedProperty[]{RENDER_PROPERTY});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    protected void func_185615_a(EntityPlayer player, World worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, this.wooden ? SoundEvents.field_187885_gS : SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
    }

    protected void func_185617_b(World worldIn, BlockPos pos) {
        worldIn.func_184133_a((EntityPlayer)null, pos, this.wooden ? SoundEvents.field_187883_gR : SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ISecretBlock.super.getActualState(state, worldIn, pos, super.func_176221_a(state, worldIn, pos));
    }
}

