/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.blocks;

import com.wynprice.secretroomsmod.SecretBlocks;
import com.wynprice.secretroomsmod.base.BaseFakeBlock;
import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import com.wynprice.secretroomsmod.render.fakemodels.FakeBlockModel;
import com.wynprice.secretroomsmod.render.fakemodels.TrueSightFaceDiffrentModel;
import com.wynprice.secretroomsmod.render.fakemodels.TrueSightModel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SecretGate
extends BaseFakeBlock {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    private static final int MAX_LEVELS = 10;

    public SecretGate() {
        super("secret_gate", Material.field_151573_f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TrueSightModel phaseTrueModel(TrueSightModel model) {
        return new TrueSightFaceDiffrentModel(model, FakeBlockModel.getModel(new ResourceLocation("secretroomsmod", "block/ghost_block")));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag1;
        boolean flag = (Boolean)state.func_177229_b((IProperty)POWERED);
        boolean bl = flag1 = worldIn.func_175640_z(pos) || worldIn.func_175687_A(pos) > 0;
        if (flag != flag1) {
            if (flag1) {
                this.buildGate(worldIn, pos);
            } else if (!flag1) {
                this.deactivateGate(worldIn, pos);
            }
        }
    }

    protected void buildGate(World worldIn, BlockPos pos) {
        EnumFacing direction = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING);
        IBlockState state = this.getState((IBlockAccess)worldIn, pos);
        worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)direction).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
        ((ISecretTileEntity)worldIn.func_175625_s(pos)).setMirrorState(state);
        BlockPos endPosition = new BlockPos(pos.func_177958_n() + 11 * direction.func_82601_c(), pos.func_177956_o() + 11 * direction.func_96559_d(), pos.func_177952_p() + 11 * direction.func_82599_e());
        for (int i = 1; i <= 10; ++i) {
            BlockPos position = new BlockPos(pos.func_177958_n() + i * direction.func_82601_c(), pos.func_177956_o() + i * direction.func_96559_d(), pos.func_177952_p() + i * direction.func_82599_e());
            if (!worldIn.func_180495_p(position).func_177230_c().func_176200_f((IBlockAccess)worldIn, position)) {
                endPosition = position;
                break;
            }
            worldIn.func_175656_a(position, SecretBlocks.SECRET_GATE_BLOCK.func_176223_P());
            if (i == 1) {
                worldIn.func_175656_a(position, SecretBlocks.SECRET_GATE_BLOCK.func_176223_P());
            }
            worldIn.func_175625_s(position).func_70296_d();
            ((ISecretBlock)worldIn.func_180495_p(pos).func_177230_c()).forceBlockState(worldIn, position, this.getState((IBlockAccess)worldIn, pos));
        }
        if (worldIn.func_180495_p(endPosition).func_177230_c() == this) {
            this.buildGate(worldIn, endPosition);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.destroyGate(worldIn, pos, state);
        super.func_180663_b(worldIn, pos, state);
    }

    protected void deactivateGate(World worldIn, BlockPos pos) {
        BlockPos position = this.destroyGate(worldIn, pos, worldIn.func_180495_p(pos));
        EnumFacing direction = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING);
        worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)direction).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        if (worldIn.func_180495_p(position).func_177230_c() == this) {
            this.deactivateGate(worldIn, position);
        }
    }

    protected BlockPos destroyGate(World worldIn, BlockPos pos, IBlockState blockstate) {
        EnumFacing direction = (EnumFacing)blockstate.func_177229_b((IProperty)FACING);
        IBlockState state = this.getState((IBlockAccess)worldIn, pos);
        ((ISecretTileEntity)worldIn.func_175625_s(pos)).setMirrorState(state);
        BlockPos endPosition = new BlockPos(pos.func_177958_n() + 11 * direction.func_82601_c(), pos.func_177956_o() + 11 * direction.func_96559_d(), pos.func_177952_p() + 11 * direction.func_82599_e());
        for (int i = 1; i < 11; ++i) {
            BlockPos position = new BlockPos(pos.func_177958_n() + i * direction.func_82601_c(), pos.func_177956_o() + i * direction.func_96559_d(), pos.func_177952_p() + i * direction.func_82599_e());
            if (worldIn.func_180495_p(position).func_177230_c() != SecretBlocks.SECRET_GATE_BLOCK) {
                return position;
            }
            worldIn.func_175698_g(position);
        }
        return endPosition;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{POWERED, FACING}, new IUnlistedProperty[]{RENDER_PROPERTY});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }
}

