/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.network.packets;

import com.wynprice.secretroomsmod.base.BaseMessagePacket;
import com.wynprice.secretroomsmod.handler.EnergizedPasteHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessagePacketSyncEnergizedPaste
extends BaseMessagePacket<MessagePacketSyncEnergizedPaste> {
    private IBlockState state;
    private int dim;
    private boolean set;
    private BlockPos pos;
    private NBTTagCompound nbt;

    public MessagePacketSyncEnergizedPaste() {
    }

    public MessagePacketSyncEnergizedPaste(NBTTagCompound nbt, BlockPos pos) {
        this.nbt = nbt;
        this.pos = pos == null ? BlockPos.field_177992_a : pos;
    }

    public MessagePacketSyncEnergizedPaste(int dim, BlockPos pos, IBlockState state, boolean set) {
        this.dim = dim;
        this.state = state == null ? Blocks.field_150348_b.func_176223_P() : state;
        this.pos = pos;
        this.set = set;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        int type = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        if (type == 0) {
            this.dim = buf.readInt();
            this.state = Block.func_176220_d((int)buf.readInt());
            this.set = buf.readBoolean();
        } else {
            this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.nbt == null ? 0 : 1);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        if (this.nbt == null) {
            buf.writeInt(this.dim);
            buf.writeInt(Block.func_176210_f((IBlockState)this.state));
            buf.writeBoolean(this.set);
        } else {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
        }
    }

    @Override
    public void onReceived(MessagePacketSyncEnergizedPaste message, EntityPlayer player) {
        if (message.nbt != null) {
            EnergizedPasteHandler.readFromNBT(message.nbt);
        } else if (!message.pos.equals((Object)BlockPos.field_177992_a)) {
            if (message.set) {
                EnergizedPasteHandler.putState(message.dim, message.pos, message.state, player.field_70170_p.func_180495_p(message.pos));
            } else {
                EnergizedPasteHandler.removeReplacedState(message.dim, message.pos);
            }
        }
        if (!message.pos.equals((Object)BlockPos.field_177992_a)) {
            player.field_70170_p.func_175704_b(message.pos.func_177982_a(-1, -1, -1), message.pos.func_177982_a(1, 1, 1));
        } else {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Minecraft.func_71410_x().field_71438_f.func_72712_a();
                }
            });
        }
    }
}

