/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.render;

import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import com.wynprice.secretroomsmod.handler.EnergizedPasteHandler;
import com.wynprice.secretroomsmod.items.TrueSightHelmet;
import com.wynprice.secretroomsmod.network.SecretNetwork;
import com.wynprice.secretroomsmod.network.packets.MessagePacketEnergizedPaste;
import com.wynprice.secretroomsmod.optifinehelpers.SecretOptifineHelper;
import com.wynprice.secretroomsmod.render.fakemodels.FakeBlockModel;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FakeChunkCache
extends ChunkCache {
    private final ChunkCache oldCache;
    private final BlockPos fromPos;
    private final BlockPos toPos;
    private final int sub;
    public int prevInt = -1;

    public FakeChunkCache(World world, BlockPos from, BlockPos to, int sub, ChunkCache oldCache) {
        super(world, from, to, sub);
        this.oldCache = oldCache;
        this.fromPos = from;
        this.toPos = to;
        this.sub = sub;
    }

    public boolean func_72806_N() {
        return this.oldCache.func_72806_N();
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.oldCache.func_180494_b(pos);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (SecretOptifineHelper.IS_OPTIFINE) {
            if (Arrays.asList("C7", "C8").contains(SecretOptifineHelper.version) && this.prevInt != -1) {
                for (Object[] objectArray : new ArrayList<IBlockState[]>(SecretOptifineHelper.CURRENT_C7_LIST)) {
                    if (objectArray == null || this.prevInt < 0 || this.prevInt >= objectArray.length) continue;
                    objectArray[this.prevInt] = null;
                }
                this.prevInt = -1;
            }
            if (super.func_180495_p(pos).func_177230_c() instanceof ISecretBlock && ISecretTileEntity.getMirrorState(this.field_72815_e, pos) != null) {
                this.prevInt = SecretOptifineHelper.getPositionIndex(this.fromPos, this.toPos, this.sub, pos);
                if (!SecretOptifineHelper.resetCached()) {
                    return this.oldCache.func_180495_p(pos);
                }
                if (((ISecretBlock)super.func_180495_p(pos).func_177230_c()).phaseModel(new FakeBlockModel(Blocks.field_150348_b.func_176223_P())).getClass() != FakeBlockModel.class && Thread.currentThread().getStackTrace()[3].getClassName().equals(RenderChunk.class.getName()) || Arrays.asList("func_187491_a", "func_175626_b").contains(Thread.currentThread().getStackTrace()[3].getMethodName()) || TrueSightHelmet.isHelmet()) {
                    return this.oldCache.func_180495_p(pos);
                }
                return ISecretTileEntity.getMirrorState(this.field_72815_e, pos);
            }
        }
        if (!(super.func_180495_p(pos).func_177230_c() instanceof ISecretBlock) && EnergizedPasteHandler.hasReplacedState(this.field_72815_e, pos) && !(Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof TrueSightHelmet)) {
            if (EnergizedPasteHandler.getSetBlockState(this.field_72815_e, pos).func_177230_c() != super.func_180495_p(pos).func_177230_c() || EnergizedPasteHandler.getSetBlockState(this.field_72815_e, pos).func_177230_c().func_176201_c(EnergizedPasteHandler.getSetBlockState(this.field_72815_e, pos)) != super.func_180495_p(pos).func_177230_c().func_176201_c(super.func_180495_p(pos))) {
                SecretNetwork.sendToServer(new MessagePacketEnergizedPaste(pos, false));
            } else {
                return EnergizedPasteHandler.getReplacedState(this.field_72815_e, pos);
            }
        }
        if (this.oldCache.func_180495_p(pos).func_177230_c() instanceof ISecretBlock) {
            return this.oldCache.func_180495_p(pos).func_177230_c().getExtendedState(this.oldCache.func_180495_p(pos).func_185899_b((IBlockAccess)this.oldCache, pos), (IBlockAccess)this.oldCache, pos);
        }
        return this.oldCache.func_180495_p(pos);
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        int i = this.getLightForExt(EnumSkyBlock.SKY, pos);
        int j = this.getLightForExt(EnumSkyBlock.BLOCK, pos);
        if (j < lightValue) {
            j = lightValue;
        }
        return i << 20 | j << 4;
    }

    @SideOnly(value=Side.CLIENT)
    private int getLightForExt(EnumSkyBlock type, BlockPos pos) {
        if (type == EnumSkyBlock.SKY && !this.field_72815_e.field_73011_w.func_191066_m()) {
            return 0;
        }
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            if (this.func_180495_p(pos).func_185916_f() || EnergizedPasteHandler.hasReplacedState(this.field_72815_e, pos)) {
                int l = 0;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int k = this.func_175628_b(type, pos.func_177972_a(enumfacing));
                    if (k > l) {
                        l = k;
                    }
                    if (l < 15) continue;
                    return l;
                }
                return l;
            }
            int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
            int j = (pos.func_177952_p() >> 4) - this.field_72816_b;
            return i >= 0 && i < this.field_72817_c.length && j >= 0 && j < this.field_72817_c[i].length && this.field_72817_c[i][j] != null ? this.field_72817_c[i][j].func_177413_a(type, pos) : type.field_77198_c;
        }
        return type.field_77198_c;
    }

    public int func_175628_b(EnumSkyBlock type, BlockPos pos) {
        return this.oldCache.func_175628_b(type, pos);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.oldCache.func_175627_a(pos, direction);
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.oldCache.func_175625_s(pos);
    }

    public TileEntity func_190300_a(BlockPos pos, Chunk.EnumCreateEntityType p_190300_2_) {
        return this.oldCache.func_190300_a(pos, p_190300_2_);
    }

    public WorldType func_175624_G() {
        return this.oldCache.func_175624_G();
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.oldCache.func_175623_d(pos);
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.oldCache.isSideSolid(pos, side, _default);
    }
}

