/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper;

import com.quantumlytangled.gravekeeper.GraveKeeperConfig;
import com.quantumlytangled.gravekeeper.block.BlockDeathChest;
import com.quantumlytangled.gravekeeper.block.TileDeathChest;
import com.quantumlytangled.gravekeeper.command.CommandList;
import com.quantumlytangled.gravekeeper.command.CommandRestore;
import com.quantumlytangled.gravekeeper.core.DeathHandler;
import com.quantumlytangled.gravekeeper.util.LoggerPrintStream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="gravekeeper", name="GraveKeeper", version="0.6.1.1", acceptedMinecraftVersions="[1.12.2]")
public class GraveKeeper {
    public static final String MODID = "gravekeeper";
    public static final String NAME = "GraveKeeper";
    public static final String VERSION = "0.6.1.1";
    @Mod.Instance(value="gravekeeper")
    public static GraveKeeper INSTANCE;
    public static Logger logger;
    public static LoggerPrintStream printStreamError;
    public static LoggerPrintStream printStreamWarn;
    public static LoggerPrintStream printStreamInfo;
    public static Block blockDeathChest;
    public static Item itemDeathCertificate;

    public GraveKeeper() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DeathHandler());
    }

    @Mod.EventHandler
    private void preInit(@Nonnull FMLPreInitializationEvent event) {
        logger = event.getModLog();
        printStreamError = new LoggerPrintStream(Level.ERROR);
        printStreamWarn = new LoggerPrintStream(Level.WARN);
        printStreamInfo = new LoggerPrintStream(Level.INFO);
        GraveKeeperConfig.onFMLpreInitialization(event.getModConfigurationDirectory());
        blockDeathChest = new BlockDeathChest();
        itemDeathCertificate = ((Item)new Item().setRegistryName("gravekeeper:death_certificate")).func_77655_b("gravekeeper.death_certificate").func_77637_a(CreativeTabs.field_78040_i);
    }

    @Mod.EventHandler
    private void preInit(@Nonnull FMLPostInitializationEvent event) {
        GraveKeeperConfig.onFMLpostInitialization();
    }

    @SubscribeEvent
    public void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)blockDeathChest);
        GameRegistry.registerTileEntity(TileDeathChest.class, (ResourceLocation)new ResourceLocation(MODID, "death_chest"));
    }

    @SubscribeEvent
    public void onRegisterItems(@Nonnull RegistryEvent.Register<Item> event) {
        ItemBlock itemBlock = new ItemBlock(blockDeathChest);
        ResourceLocation resourceLocation = blockDeathChest.getRegistryName();
        assert (resourceLocation != null);
        ((Item)itemBlock.setRegistryName(blockDeathChest.getRegistryName())).func_77637_a(CreativeTabs.field_78040_i);
        event.getRegistry().register((IForgeRegistryEntry)itemBlock);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)new ModelResourceLocation(resourceLocation, "inventory"));
        }
        resourceLocation = itemDeathCertificate.getRegistryName();
        assert (resourceLocation != null);
        event.getRegistry().register((IForgeRegistryEntry)itemDeathCertificate);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ModelLoader.setCustomModelResourceLocation((Item)itemDeathCertificate, (int)0, (ModelResourceLocation)new ModelResourceLocation(resourceLocation, "inventory"));
        }
    }

    @Mod.EventHandler
    public void onFMLServerStarting(@Nonnull FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandList());
        event.registerServerCommand((ICommand)new CommandRestore());
    }
}

