/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.block;

import com.quantumlytangled.gravekeeper.GraveKeeper;
import com.quantumlytangled.gravekeeper.block.TileDeathChest;
import com.quantumlytangled.gravekeeper.util.WorldPosition;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDeathChest
extends Block {
    private final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockDeathChest() {
        super(Material.field_151574_g);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.setRegistryName("gravekeeper:death_chest");
        this.func_149663_c("gravekeeper.death_chest");
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileDeathChest)) {
            player.func_145747_a((ITextComponent)new TextComponentString(String.format("Invalid tile entity %s", tileEntity)));
            return true;
        }
        TileDeathChest tileDeathChest = (TileDeathChest)tileEntity;
        tileDeathChest.processInteraction((EntityPlayerMP)player);
        return true;
    }

    public void onBlockExploded(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull Explosion explosion) {
        EntityPlayer player = world.func_184137_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, 6.0, false);
        GraveKeeper.logger.warn(String.format("Death chest exploded at %s (%d %d %d) due to %s in proximity of player %s", WorldPosition.format(world), blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), explosion, player));
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        if (world.field_72995_K) {
            super.func_180663_b(world, blockPos, blockState);
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileDeathChest)) {
            super.func_180663_b(world, blockPos, blockState);
            return;
        }
        TileDeathChest tileDeathChest = (TileDeathChest)tileEntity;
        EntityPlayer player = world.func_184137_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, 6.0, false);
        GraveKeeper.logger.warn(String.format("Death chest broken at %s (%d %d %d) in proximity of player %s", WorldPosition.format(world), blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), player));
        tileDeathChest.doDropContent();
    }

    public boolean hasTileEntity(@Nonnull IBlockState blockState) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState blockState) {
        return new TileDeathChest();
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState blockState) {
        return EnumPushReaction.BLOCK;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState blockState) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos) {
        return this.BOUNDING_BOX;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess blockAccess, @Nonnull IBlockState blockState, @Nonnull BlockPos blockPos, @Nonnull EnumFacing enumFacing) {
        return enumFacing == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

