/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.block;

import com.quantumlytangled.gravekeeper.GraveKeeper;
import com.quantumlytangled.gravekeeper.GraveKeeperConfig;
import com.quantumlytangled.gravekeeper.core.CreationDate;
import com.quantumlytangled.gravekeeper.core.InventoryHandler;
import com.quantumlytangled.gravekeeper.util.InventorySlot;
import com.quantumlytangled.gravekeeper.util.WorldPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class TileDeathChest
extends TileEntity {
    private String dataIdentifier = "";
    private String ownerName = "";
    private UUID ownerUUID = null;
    private long creationDate = 0L;
    private List<InventorySlot> inventorySlots = new ArrayList<InventorySlot>();

    public void processInteraction(@Nonnull EntityPlayerMP player) {
        boolean isCreative = player.func_184812_l_();
        boolean isOwner = this.ownerUUID == null || this.ownerUUID.getLeastSignificantBits() == 0L && this.ownerUUID.getMostSignificantBits() == 0L || player.func_110124_au().equals(this.ownerUUID);
        long timeRemaining = CreationDate.getRemainingSeconds(this.creationDate);
        if (isCreative || player.func_70093_af()) {
            this.doInspection((EntityPlayer)player, isCreative, isOwner, timeRemaining);
        } else if (isOwner) {
            this.doReturnToOwner(player);
        } else if ((GraveKeeperConfig.INSTANT_FOREIGN_COLLECTION || timeRemaining <= 0L) && !GraveKeeperConfig.OWNER_ONLY_COLLECTION) {
            GraveKeeper.logger.warn(String.format("Death chest dropping content at %s (%d %d %d) by player %s", WorldPosition.format(this.field_145850_b), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), player));
            this.doDropContent();
        } else {
            this.doInspection((EntityPlayer)player, false, false, timeRemaining);
        }
    }

    public void setData(@Nonnull EntityPlayer player, @Nonnull String identifier, long creationDate, @Nonnull List<InventorySlot> inventorySlots) {
        this.dataIdentifier = identifier;
        this.ownerName = player.getDisplayNameString();
        this.ownerUUID = player.func_110124_au();
        this.creationDate = creationDate;
        this.inventorySlots = inventorySlots.stream().filter(inventorySlot -> !inventorySlot.isCharmed && !inventorySlot.isSoulbound).collect(Collectors.toList());
        this.func_70296_d();
    }

    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList nbtInventorySlots = tagCompound.func_150295_c("InventorySlots", 10);
        for (int index = 0; index < nbtInventorySlots.func_74745_c(); ++index) {
            NBTTagCompound nbtInventorySlot = nbtInventorySlots.func_150305_b(index);
            this.inventorySlots.add(new InventorySlot(nbtInventorySlot));
        }
        this.dataIdentifier = tagCompound.func_74779_i("DataIdentifier");
        this.ownerName = tagCompound.func_74779_i("OwnerName");
        this.ownerUUID = tagCompound.func_186857_a("OwnerUUID");
        this.creationDate = tagCompound.func_74763_f("CreationDate");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList nbtInventorySlots = new NBTTagList();
        for (InventorySlot inventorySlot : this.inventorySlots) {
            nbtInventorySlots.func_74742_a((NBTBase)inventorySlot.writeToNBT());
        }
        tagCompound.func_74778_a("DataIdentifier", this.dataIdentifier);
        tagCompound.func_74778_a("OwnerName", this.ownerName);
        if (this.ownerUUID != null) {
            tagCompound.func_186854_a("OwnerUUID", this.ownerUUID);
        }
        tagCompound.func_74772_a("CreationDate", this.creationDate);
        tagCompound.func_74782_a("InventorySlots", (NBTBase)nbtInventorySlots);
        return tagCompound;
    }

    private void doInspection(@Nonnull EntityPlayer player, boolean isCreative, boolean isOwner, long timeRemaining) {
        TextComponentTranslation textMessageToSend;
        TextComponentString textOwner = new TextComponentString(this.ownerName == null ? "-null-" : this.ownerName);
        textOwner.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(this.ownerUUID == null ? "-null-" : this.ownerUUID.toString()))).func_150238_a(TextFormatting.AQUA);
        TextComponentString textDuration = new TextComponentString(DurationFormatUtils.formatDurationWords((long)Math.abs(timeRemaining * 1000L), (boolean)true, (boolean)true));
        textDuration.func_150256_b().func_150238_a(TextFormatting.RED);
        TextComponentString textSize = new TextComponentString(String.format("%d", this.inventorySlots.size()));
        textSize.func_150256_b().func_150238_a(TextFormatting.AQUA);
        if (isOwner) {
            if (timeRemaining <= 0L) {
                textMessageToSend = new TextComponentTranslation("gravekeeper.chat.inspect.elapsed_yours", new Object[]{textOwner, textDuration, textSize});
                textMessageToSend.func_150256_b().func_150238_a(TextFormatting.GREEN);
            } else if (!GraveKeeperConfig.OWNER_ONLY_COLLECTION) {
                textMessageToSend = new TextComponentTranslation("gravekeeper.chat.inspect.delayed_yours", new Object[]{textOwner, textDuration, textSize});
                textMessageToSend.func_150256_b().func_150238_a(TextFormatting.GREEN);
            } else {
                textMessageToSend = new TextComponentTranslation("gravekeeper.chat.inspect.guarded_yours", new Object[]{textOwner, textDuration, textSize});
                textMessageToSend.func_150256_b().func_150238_a(TextFormatting.GREEN);
            }
        } else if (timeRemaining <= 0L) {
            textMessageToSend = new TextComponentTranslation("gravekeeper.chat.inspect.elapsed_other", new Object[]{textOwner, textDuration, textSize});
            textMessageToSend.func_150256_b().func_150238_a(TextFormatting.GREEN);
        } else if (!GraveKeeperConfig.OWNER_ONLY_COLLECTION) {
            textMessageToSend = new TextComponentTranslation("gravekeeper.chat.inspect.delayed_other", new Object[]{textOwner, textDuration, textSize});
            textMessageToSend.func_150256_b().func_150238_a(TextFormatting.GOLD);
        } else {
            textMessageToSend = new TextComponentTranslation("gravekeeper.chat.inspect.guarded_other", new Object[]{textOwner, textDuration, textSize});
            textMessageToSend.func_150256_b().func_150238_a(TextFormatting.GOLD);
        }
        player.func_145747_a((ITextComponent)textMessageToSend);
        if (isCreative && (isOwner || timeRemaining <= 0L)) {
            textMessageToSend = new TextComponentTranslation("gravekeeper.chat.inspect.survival_required", new Object[]{textOwner, textDuration, textSize});
            textMessageToSend.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)textMessageToSend);
        }
    }

    protected void dropItem(ItemStack itemStack) {
        try {
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, itemStack);
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GraveKeeper.logger.info(String.format("Failed to drop item %s", itemStack));
        }
    }

    protected void doDropContent() {
        for (InventorySlot inventory : this.inventorySlots) {
            this.dropItem(inventory.itemStack);
        }
        this.inventorySlots.clear();
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175698_g(this.field_174879_c);
    }

    private void doReturnToOwner(@Nonnull EntityPlayerMP player) {
        List<ItemStack> overflow = InventoryHandler.restoreOrOverflow(player, this.inventorySlots, false);
        for (ItemStack itemStack : overflow) {
            if (player.field_71071_by.func_70441_a(itemStack)) continue;
            this.dropItem(itemStack);
        }
        this.inventorySlots.clear();
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175698_g(this.field_174879_c);
    }
}

