/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.command;

import com.quantumlytangled.gravekeeper.core.CreationDate;
import com.quantumlytangled.gravekeeper.core.GraveData;
import com.quantumlytangled.gravekeeper.util.NBTFile;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CommandList
extends CommandBase {
    public ITextComponent getPrefix() {
        return new TextComponentString("/" + this.func_71517_b()).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)).func_150257_a((ITextComponent)new TextComponentString(" "));
    }

    @Nonnull
    public String func_71517_b() {
        return "gklist";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender commandSender) {
        return "/gklist <playerName>: list all known graves from an online player\n/gklist <playerUUID>: list all known graves from a player";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender commandSender, @Nonnull String[] args) {
        File[] sortedFiles;
        UUID uuidPlayer;
        EntityPlayerMP entityPlayer;
        EntityPlayerMP entityPlayerMP = entityPlayer = commandSender instanceof EntityPlayerMP ? (EntityPlayerMP)commandSender : null;
        if (args.length != 1) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        String argument = args[0];
        if (argument.length() == 36) {
            if (entityPlayer == null) {
                commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString("Unable to list graves by UUID from console, sorry.").func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
                return;
            }
            try {
                uuidPlayer = UUID.fromString(argument);
            }
            catch (IllegalArgumentException exception) {
                commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Invalid player UUID %s", argument)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
                return;
            }
        } else {
            boolean isMissing = true;
            List onlinePlayers = server.func_184103_al().func_181057_v();
            for (EntityPlayerMP onlinePlayer : onlinePlayers) {
                if (!onlinePlayer.func_70005_c_().equalsIgnoreCase(argument) && !onlinePlayer.getDisplayNameString().equalsIgnoreCase(argument)) continue;
                entityPlayer = onlinePlayer;
                isMissing = false;
                break;
            }
            if (isMissing) {
                commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Unable to find player with name %s: player is offline or name is incorrect. Try using their UUID instead.", argument)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
                return;
            }
            uuidPlayer = entityPlayer.func_110124_au();
        }
        String identifier = uuidPlayer.toString();
        String stringDirectory = String.format("%s/data/%s/%s", entityPlayer.field_70170_p.func_72860_G().func_75765_b().getPath(), "gravekeeper", identifier.substring(0, 2));
        File fileDirectory = new File(stringDirectory);
        if (!fileDirectory.exists()) {
            commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Unable to find archive directory for player %s", argument)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
            return;
        }
        File[] rawFiles = fileDirectory.listFiles((dir, name) -> name.startsWith(identifier) && name.endsWith(".dat"));
        if (rawFiles == null || rawFiles.length == 0) {
            commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Unable to find any backup for player %s", argument)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
            return;
        }
        TextComponentTranslation textSender = new TextComponentTranslation("gravekeeper.command.list_header", new Object[]{rawFiles.length, argument});
        textSender.func_150256_b().func_150238_a(TextFormatting.GREEN);
        commandSender.func_145747_a((ITextComponent)textSender);
        List listCommands = server.func_71187_D().func_71557_a(commandSender);
        boolean canRestore = false;
        boolean canTeleport = false;
        boolean canTeleportPos = false;
        for (ICommand command : listCommands) {
            canRestore |= command.func_71517_b().equals("gkrestore");
            canTeleport |= command.func_71517_b().equals("tp");
            canTeleportPos |= command.func_71517_b().equals("tppos");
        }
        for (File file : sortedFiles = (File[])Arrays.stream(rawFiles).sorted(Comparator.reverseOrder()).limit(10L).toArray(File[]::new)) {
            TextComponentString textPosition;
            GraveData graveData;
            String name2 = file.getName().substring(0, file.getName().length() - 4);
            String timestampMilliseconds = name2.substring(name2.lastIndexOf("_") - 10);
            String timestampSeconds = name2.substring(name2.lastIndexOf("_") - 10, name2.length() - 4);
            CreationDate creationDate = new CreationDate(timestampMilliseconds);
            String elapsedTime = creationDate.getElapsedTime();
            String presentedTime = elapsedTime.length() > timestampSeconds.length() ? timestampSeconds : elapsedTime + " ago";
            boolean isExpired = CreationDate.getRemainingSeconds(creationDate.seconds) <= 0L;
            NBTTagCompound tagData = NBTFile.read(file);
            try {
                graveData = tagData == null ? null : new GraveData(tagData);
            }
            catch (Exception exception) {
                graveData = null;
                exception.printStackTrace();
            }
            TextComponentString textTime = new TextComponentString(presentedTime);
            textTime.func_150256_b().func_150238_a(isExpired ? TextFormatting.YELLOW : TextFormatting.GREEN);
            if (canRestore) {
                textTime.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/gkrestore %s", name2))).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(String.format("%s\nClick to suggest restore command", timestampSeconds))));
            } else {
                textTime.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(timestampSeconds)));
            }
            if (graveData == null) {
                textPosition = new TextComponentString(" -invalid backup-");
                textPosition.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Check console logs for further details"))).func_150238_a(TextFormatting.RED);
            } else if (graveData.worldPositionPlayer == null || graveData.worldPositionGrave == null) {
                textPosition = new TextComponentString(" -unknown position-");
                textPosition.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Backup uses legacy format\nCheck console or client chat logs at time of death for coordinates"))).func_150238_a(TextFormatting.RED);
            } else {
                textPosition = new TextComponentString(" " + graveData.worldPositionPlayer.format());
                if (graveData.worldPositionGrave.isSameWorld(entityPlayer.field_70170_p)) {
                    BlockPos blockPos = graveData.worldPositionGrave.blockPos;
                    if (canTeleportPos) {
                        textPosition.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/tppos %d %d %d", blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()))).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to suggest tp command"))).func_150238_a(TextFormatting.AQUA);
                    } else if (canTeleport) {
                        textPosition.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/tp %d %d %d", blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()))).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to suggest tp command"))).func_150238_a(TextFormatting.AQUA);
                    } else {
                        textPosition.func_150256_b().func_150238_a(TextFormatting.GREEN);
                    }
                } else {
                    textPosition.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Enter that dimension before you can teleport"))).func_150238_a(TextFormatting.YELLOW);
                }
            }
            commandSender.func_145747_a(textTime.func_150257_a((ITextComponent)textPosition));
        }
    }
}

