/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.command;

import com.quantumlytangled.gravekeeper.GraveKeeper;
import com.quantumlytangled.gravekeeper.core.GraveData;
import com.quantumlytangled.gravekeeper.core.InventoryHandler;
import com.quantumlytangled.gravekeeper.util.NBTFile;
import java.io.File;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class CommandRestore
extends CommandBase {
    public ITextComponent getPrefix() {
        return new TextComponentString("/" + this.func_71517_b()).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)).func_150257_a((ITextComponent)new TextComponentString(" "));
    }

    @Nonnull
    public String func_71517_b() {
        return "gkrestore";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender commandSender) {
        return "/gkrestore <identifier>: restore an online player's inventory\n/gkrestore <playerName> <identifier>: restore an inventory to another online player";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender commandSender, @Nonnull String[] args) {
        GraveData graveData;
        String stringDirectory;
        File fileDirectory;
        List onlinePlayers;
        String identifier;
        EntityPlayerMP entityPlayer = null;
        if (args.length == 0 || args.length > 2) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
                commandSender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
                return;
            }
            identifier = args[0];
            if (identifier.length() < 61) {
                commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Invalid identifier %s", identifier)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
                return;
            }
            UUID uuidPlayer = UUID.fromString(identifier.substring(0, 36));
            onlinePlayers = server.func_184103_al().func_181057_v();
            for (EntityPlayerMP onlinePlayer : onlinePlayers) {
                if (!onlinePlayer.getPersistentID().equals(uuidPlayer)) continue;
                entityPlayer = onlinePlayer;
                break;
            }
            if (entityPlayer == null) {
                commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Unable to find player with UUID %s: player is offline or identifier is incorrect", uuidPlayer)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
                return;
            }
        } else {
            String namePlayer = args[0];
            identifier = args[1];
            if (identifier.length() < 61) {
                commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Invalid identifier %s", identifier)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
                return;
            }
            onlinePlayers = server.func_184103_al().func_181057_v();
            for (EntityPlayerMP onlinePlayer : onlinePlayers) {
                if (!onlinePlayer.func_70005_c_().equalsIgnoreCase(namePlayer)) continue;
                entityPlayer = onlinePlayer;
                break;
            }
            if (entityPlayer == null) {
                commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Unable to find player with name %s: player is offline or name is incorrect", namePlayer)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
                return;
            }
        }
        if (!(fileDirectory = new File(stringDirectory = String.format("%s/data/%s/%s", entityPlayer.field_70170_p.func_72860_G().func_75765_b().getPath(), "gravekeeper", identifier.substring(0, 2)))).exists()) {
            commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Unable to find archive directory for identifier %s", identifier)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
            return;
        }
        try {
            String stringFilePath = String.format("%s/%s.dat", stringDirectory, identifier);
            NBTTagCompound nbtGraveData = NBTFile.read(stringFilePath);
            if (nbtGraveData == null) {
                commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Unable to read archived inventory for identifier %s", identifier)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
                return;
            }
            graveData = new GraveData(nbtGraveData);
        }
        catch (Exception exception) {
            exception.printStackTrace(GraveKeeper.printStreamError);
            commandSender.func_145747_a(this.getPrefix().func_150257_a(new TextComponentString(String.format("Error trying to read archived inventory for identifier %s, check console for details", identifier)).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
            return;
        }
        List<ItemStack> overflow = InventoryHandler.restoreOrOverflow(entityPlayer, graveData.inventorySlots, entityPlayer.func_184812_l_());
        for (ItemStack itemStack : overflow) {
            if (entityPlayer.field_71071_by.func_70441_a(itemStack.func_77946_l())) continue;
            entityPlayer.field_70170_p.func_72838_d((Entity)new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, itemStack));
        }
        TextComponentTranslation textSender = new TextComponentTranslation("gravekeeper.command.restored_sender", new Object[]{entityPlayer.func_145748_c_()});
        textSender.func_150256_b().func_150238_a(TextFormatting.GREEN);
        commandSender.func_145747_a((ITextComponent)textSender);
        GraveKeeper.logger.info(textSender.func_150260_c());
        if (!commandSender.equals(entityPlayer)) {
            TextComponentTranslation textTarget = new TextComponentTranslation("gravekeeper.command.restored_target", new Object[0]);
            textTarget.func_150256_b().func_150238_a(TextFormatting.GREEN);
            entityPlayer.func_145747_a((ITextComponent)textTarget);
        }
    }
}

