/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.core;

import com.quantumlytangled.gravekeeper.GraveKeeperConfig;
import com.quantumlytangled.gravekeeper.util.InventoryType;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class CharmHandler {
    public static Mode updateMode(@Nonnull Mode modeCurrent, @Nonnull ItemStack itemStack) {
        Mode modeItem = GraveKeeperConfig.CHARM_ARMOR_HELD_ITEMS.contains(itemStack.func_77973_b()) ? Mode.ARMOUR_HELD : (GraveKeeperConfig.CHARM_ARMOR_HOTBAR_ITEMS.contains(itemStack.func_77973_b()) ? Mode.ARMOUR_HOTBAR : (GraveKeeperConfig.CHARM_FULL_ITEMS.contains(itemStack.func_77973_b()) ? Mode.FULL : Mode.NONE));
        return modeCurrent.ordinal() > modeItem.ordinal() ? modeCurrent : modeItem;
    }

    public static boolean isCharmed(@Nonnull Mode mode, int slotHeld, @Nonnull InventoryType inventoryType, int slot, @Nonnull ItemStack itemStack) {
        switch (mode) {
            default: {
                break;
            }
            case ARMOUR_HELD: {
                if (inventoryType == InventoryType.ARMOUR) {
                    return true;
                }
                if (inventoryType != InventoryType.MAIN || slot != slotHeld) break;
                return true;
            }
            case ARMOUR_HOTBAR: {
                if (inventoryType == InventoryType.ARMOUR) {
                    return true;
                }
                if (inventoryType != InventoryType.MAIN || slot >= 9) break;
                return true;
            }
            case FULL: {
                if (inventoryType != InventoryType.ARMOUR && inventoryType != InventoryType.OFFHAND && inventoryType != InventoryType.MAIN && inventoryType != InventoryType.BAUBLES) break;
                return true;
            }
        }
        return (inventoryType == InventoryType.MAIN || inventoryType == InventoryType.BAUBLES) && GraveKeeperConfig.CHARM_ITEMS.contains(itemStack.func_77973_b());
    }

    public static enum Mode {
        NONE,
        ARMOUR_HELD,
        ARMOUR_HOTBAR,
        FULL;

    }
}

