/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.core;

import com.quantumlytangled.gravekeeper.GraveKeeperConfig;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class CreationDate {
    public long seconds;
    public String string;

    public CreationDate() {
        ZonedDateTime utcTimeStamp = ZonedDateTime.now(ZoneOffset.UTC);
        this.seconds = utcTimeStamp.getLong(ChronoField.INSTANT_SECONDS);
        this.string = utcTimeStamp.format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss.SSS"));
    }

    public CreationDate(String string) {
        this.seconds = ZonedDateTime.parse(string, DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss.SSS").withZone(ZoneOffset.UTC)).getLong(ChronoField.INSTANT_SECONDS);
        this.string = string;
    }

    @Nonnull
    public String getElapsedTime() {
        long elapsedTime = this.seconds - new CreationDate().seconds;
        return DurationFormatUtils.formatDurationWords((long)Math.abs(elapsedTime * 1000L), (boolean)true, (boolean)true);
    }

    public static long getRemainingSeconds(long creationDate) {
        if (GraveKeeperConfig.INSTANT_FOREIGN_COLLECTION) {
            return 0L;
        }
        if (GraveKeeperConfig.OWNER_ONLY_COLLECTION) {
            return Long.MAX_VALUE;
        }
        return creationDate + (long)GraveKeeperConfig.EXPIRE_TIME_SECONDS - new CreationDate().seconds;
    }
}

