/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.core;

import com.quantumlytangled.gravekeeper.GraveKeeper;
import com.quantumlytangled.gravekeeper.GraveKeeperConfig;
import com.quantumlytangled.gravekeeper.block.TileDeathChest;
import com.quantumlytangled.gravekeeper.core.CreationDate;
import com.quantumlytangled.gravekeeper.core.GraveData;
import com.quantumlytangled.gravekeeper.core.GravePosition;
import com.quantumlytangled.gravekeeper.core.InventoryHandler;
import com.quantumlytangled.gravekeeper.util.InventorySlot;
import com.quantumlytangled.gravekeeper.util.NBTFile;
import com.quantumlytangled.gravekeeper.util.WorldPosition;
import java.io.File;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FileUtils;

public final class DeathHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(@Nonnull LivingDeathEvent event) {
        if (event.isCanceled()) {
            GraveKeeper.logger.debug(String.format("Event is cancelled, ignoring death event of %s", event.getEntity()));
            return;
        }
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (!(entityLiving instanceof EntityPlayer) || !entityLiving.func_70613_aW()) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityLiving;
        if (!GraveKeeperConfig.IGNORE_KEEP_INVENTORY && player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            GraveKeeper.logger.debug(String.format("Keep inventory is enabled, ignoring death of player %s", player));
            return;
        }
        CreationDate creationDate = new CreationDate();
        String stringTimestamp = creationDate.string;
        String playerName = player.getDisplayNameString();
        UUID playerUUID = player.func_110124_au();
        String identifier = playerUUID + "_" + playerName + "_" + stringTimestamp;
        List<InventorySlot> inventorySlots = InventoryHandler.collectOnDeath(player);
        if (inventorySlots.isEmpty()) {
            GraveKeeper.logger.warn(String.format("No item to save, ignoring death of player %s", player));
            return;
        }
        WorldPosition worldPositionPlayer = new WorldPosition(player.field_70170_p, new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v)));
        WorldPosition worldPositionGrave = GravePosition.get((EntityPlayer)player, worldPositionPlayer.blockPos);
        GraveData graveData = new GraveData(inventorySlots, worldPositionPlayer, worldPositionGrave);
        String stringDirectory = String.format("%s/data/%s/%s", player.field_70170_p.func_72860_G().func_75765_b().getPath(), "gravekeeper", identifier.substring(0, 2));
        File fileDirectory = new File(stringDirectory);
        try {
            FileUtils.forceMkdir((File)fileDirectory);
            NBTTagCompound nbtGraveData = graveData.writeToNBT();
            String stringFilePath = String.format("%s/%s.dat", stringDirectory, identifier);
            NBTFile.write(stringFilePath, nbtGraveData);
            GraveKeeper.logger.info(String.format("Archived DeathChest content for %s, restore it with /gkrestore %s", playerName, identifier));
        }
        catch (Exception exception) {
            exception.printStackTrace(GraveKeeper.printStreamWarn);
            GraveKeeper.logger.warn(String.format("Failed to create inventory backup for player %s", player));
        }
        boolean anyGraveContent = inventorySlots.stream().anyMatch(inventorySlot -> !inventorySlot.isCharmed && !inventorySlot.isSoulbound);
        if (!anyGraveContent) {
            GraveKeeper.logger.warn(String.format("No item to save, ignoring death of player %s", player));
            return;
        }
        worldPositionGrave.getWorld().func_175656_a(worldPositionGrave.blockPos, GraveKeeper.blockDeathChest.func_176223_P());
        TileEntity tileEntity = worldPositionGrave.getWorld().func_175625_s(worldPositionGrave.blockPos);
        if (!(tileEntity instanceof TileDeathChest)) {
            GraveKeeper.logger.error(String.format("Missing tile entity %s, unable to save player %s inventory in world %s at %s", tileEntity, playerName, worldPositionGrave.getWorld(), worldPositionGrave.blockPos));
            return;
        }
        TileDeathChest tileDeathChest = (TileDeathChest)tileEntity;
        tileDeathChest.setData((EntityPlayer)player, identifier, creationDate.seconds, inventorySlots);
        GraveKeeper.logger.info(String.format("Generated DeathChest for %s (%s) in DIM%d at (%d %d %d).", playerName, playerUUID, worldPositionGrave.getWorld().field_73011_w.getDimension(), worldPositionGrave.blockPos.func_177958_n(), worldPositionGrave.blockPos.func_177956_o(), worldPositionGrave.blockPos.func_177952_p()));
        TextComponentString textLocation = new TextComponentString(worldPositionGrave.format());
        textLocation.func_150256_b().func_150238_a(TextFormatting.AQUA).func_150227_a(Boolean.valueOf(true));
        TextComponentTranslation textMessage = new TextComponentTranslation("gravekeeper.chat.grave_placed", new Object[]{textLocation});
        textMessage.func_150256_b().func_150238_a(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)textMessage);
    }
}

