/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.core;

import com.quantumlytangled.gravekeeper.util.InventorySlot;
import com.quantumlytangled.gravekeeper.util.WorldPosition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GraveData {
    private static final int VERSION = 2;
    public final List<InventorySlot> inventorySlots;
    public final WorldPosition worldPositionPlayer;
    public final WorldPosition worldPositionGrave;

    public GraveData(@Nonnull List<InventorySlot> inventorySlots, @Nonnull WorldPosition worldPositionPlayer, @Nonnull WorldPosition worldPositionGrave) {
        this.inventorySlots = inventorySlots;
        this.worldPositionPlayer = worldPositionPlayer;
        this.worldPositionGrave = worldPositionGrave;
    }

    @Nonnull
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tagContainer = new NBTTagCompound();
        tagContainer.func_74778_a("modid", "gravekeeper");
        tagContainer.func_74778_a("mod_version", "0.6.1.1");
        tagContainer.func_74768_a("format_version", 2);
        tagContainer.func_74782_a("deathPosition", (NBTBase)this.worldPositionPlayer.writeToNBT(new NBTTagCompound()));
        tagContainer.func_74782_a("gravePosition", (NBTBase)this.worldPositionGrave.writeToNBT(new NBTTagCompound()));
        NBTTagList tagSlots = new NBTTagList();
        for (InventorySlot inventorySlot : this.inventorySlots) {
            tagSlots.func_74742_a((NBTBase)inventorySlot.writeToNBT());
        }
        tagContainer.func_74782_a("inventory_slots", (NBTBase)tagSlots);
        return tagContainer;
    }

    public GraveData(@Nonnull NBTTagCompound tagContainer) {
        String modid = tagContainer.func_74779_i("modid");
        if (!modid.equals("gravekeeper")) {
            throw new RuntimeException(String.format("Invalid InventorySlots format: unknown modid %s", modid));
        }
        int version = tagContainer.func_74762_e("format_version");
        if (version > 2) {
            throw new RuntimeException(String.format("Invalid InventorySlots format: unknown version %d", version));
        }
        if (version >= 2) {
            this.worldPositionPlayer = new WorldPosition(tagContainer.func_74775_l("deathPosition"));
            this.worldPositionGrave = new WorldPosition(tagContainer.func_74775_l("gravePosition"));
        } else {
            this.worldPositionPlayer = null;
            this.worldPositionGrave = null;
        }
        NBTTagList tagSlots = tagContainer.func_150295_c("inventory_slots", 10);
        this.inventorySlots = new ArrayList<InventorySlot>(tagSlots.func_74745_c());
        for (NBTBase tagSlot : tagSlots) {
            assert (tagSlot instanceof NBTTagCompound);
            this.inventorySlots.add(new InventorySlot((NBTTagCompound)tagSlot));
        }
    }
}

