/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.core;

import com.quantumlytangled.gravekeeper.GraveKeeper;
import com.quantumlytangled.gravekeeper.GraveKeeperConfig;
import com.quantumlytangled.gravekeeper.util.WorldPosition;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class GravePosition {
    @Nonnull
    public static WorldPosition get(@Nonnull EntityPlayer entityPlayer, @Nonnull BlockPos blockPosInitial) {
        WorldPosition worldPositionResult = new WorldPosition(entityPlayer.field_70170_p, blockPosInitial);
        if (worldPositionResult.blockPos.func_177956_o() <= GraveKeeperConfig.USE_BED_OR_SPAWN_LOCATION_BELOW_Y) {
            GravePosition.updateWithBedOrSpawn(entityPlayer, worldPositionResult);
        }
        if (worldPositionResult.blockPos.func_177956_o() >= worldPositionResult.getWorld().func_72800_K()) {
            worldPositionResult.blockPos = new BlockPos(worldPositionResult.blockPos.func_177958_n(), worldPositionResult.getWorld().func_72800_K() - 1, worldPositionResult.blockPos.func_177952_p());
        } else if (worldPositionResult.blockPos.func_177956_o() < GraveKeeperConfig.SEARCH_MIN_ALTITUDE) {
            worldPositionResult.blockPos = new BlockPos(worldPositionResult.blockPos.func_177958_n(), GraveKeeperConfig.SEARCH_MIN_ALTITUDE, worldPositionResult.blockPos.func_177952_p());
        }
        if (GravePosition.isFreeSpot(worldPositionResult.getWorld(), worldPositionResult.blockPos, true, false)) {
            return worldPositionResult;
        }
        if (GravePosition.updateWithNearbyFreeSpot(worldPositionResult)) {
            return worldPositionResult;
        }
        boolean isFlying = GravePosition.isFreeSpot(worldPositionResult.getWorld(), worldPositionResult.blockPos, false, false);
        if (GravePosition.updateVertically(worldPositionResult, isFlying)) {
            return worldPositionResult;
        }
        GraveKeeper.logger.info(String.format("Player has no safe spot for its grave, releasing direction: %s %s", entityPlayer, worldPositionResult.blockPos));
        if (GravePosition.updateVertically(worldPositionResult, isFlying)) {
            return worldPositionResult;
        }
        if (isFlying) {
            if (GraveKeeperConfig.DEBUG_LOGS) {
                GraveKeeper.logger.info(String.format("Assuming void area, defaulting to (%d %d %d)", worldPositionResult.blockPos.func_177958_n(), worldPositionResult.blockPos.func_177956_o(), worldPositionResult.blockPos.func_177952_p()));
            }
            return worldPositionResult;
        }
        IBlockState blockState = worldPositionResult.getWorld().func_180495_p(worldPositionResult.blockPos);
        TileEntity tileEntity = worldPositionResult.getWorld().func_175625_s(worldPositionResult.blockPos);
        GraveKeeper.logger.warn(String.format("Can't find free slot for grave, deleting %s with tile entity %s at %s", blockState, tileEntity, worldPositionResult.blockPos));
        if (tileEntity != null) {
            try {
                NBTTagCompound nbtTagCompound = tileEntity.func_189515_b(new NBTTagCompound());
                GraveKeeper.logger.info(String.format("NBT is %s", nbtTagCompound));
            }
            catch (Exception exception) {
                exception.printStackTrace(GraveKeeper.printStreamError);
            }
        }
        return worldPositionResult;
    }

    private static void updateWithBedOrSpawn(@Nonnull EntityPlayer entityPlayer, @Nonnull WorldPosition worldPositionResult) {
        BlockPos blockPosBed = entityPlayer.getBedLocation(entityPlayer.field_71093_bK);
        if (blockPosBed != null) {
            worldPositionResult.blockPos = blockPosBed.func_177984_a().func_177968_d();
        } else {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(GraveKeeperConfig.SPAWN_DIMENSION_ID);
            if (world != null) {
                blockPosBed = entityPlayer.getBedLocation(GraveKeeperConfig.SPAWN_DIMENSION_ID);
                worldPositionResult.setWorld((World)world);
                worldPositionResult.blockPos = blockPosBed != null ? blockPosBed.func_177984_a().func_177968_d() : worldPositionResult.getWorld().func_175694_M().func_177984_a();
            } else {
                GraveKeeper.logger.warn(String.format("Failed to load spawn dimension with id %s, check console for details and review your configuration accordingly.", GraveKeeperConfig.SPAWN_DIMENSION_ID));
            }
        }
    }

    private static boolean updateWithNearbyFreeSpot(@Nonnull WorldPosition worldPositionResult) {
        if (GraveKeeperConfig.DEBUG_LOGS) {
            GraveKeeper.logger.info(String.format("Starting position is %s, searching nearby", worldPositionResult.blockPos));
        }
        int xMin = worldPositionResult.blockPos.func_177958_n() - GraveKeeperConfig.SEARCH_RADIUS_HORIZONTAL_M;
        int xMax = worldPositionResult.blockPos.func_177958_n() + GraveKeeperConfig.SEARCH_RADIUS_HORIZONTAL_M;
        int yMin = Math.max(worldPositionResult.blockPos.func_177956_o() - GraveKeeperConfig.SEARCH_RADIUS_BELOW_M, GraveKeeperConfig.SEARCH_MIN_ALTITUDE);
        int yMax = Math.min(worldPositionResult.blockPos.func_177956_o() + GraveKeeperConfig.SEARCH_RADIUS_ABOVE_M, worldPositionResult.getWorld().func_72800_K() - 1);
        int zMin = worldPositionResult.blockPos.func_177952_p() - GraveKeeperConfig.SEARCH_RADIUS_HORIZONTAL_M;
        int zMax = worldPositionResult.blockPos.func_177952_p() + GraveKeeperConfig.SEARCH_RADIUS_HORIZONTAL_M;
        Vec3d vStarting = new Vec3d((double)worldPositionResult.blockPos.func_177958_n() + 0.5, (double)worldPositionResult.blockPos.func_177956_o() + 0.5, (double)worldPositionResult.blockPos.func_177952_p() + 0.5);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(worldPositionResult.blockPos);
        BlockPos blockPosVisible = worldPositionResult.blockPos;
        BlockPos blockPosHidden = worldPositionResult.blockPos;
        int distanceClosestVisible = Integer.MAX_VALUE;
        int distanceClosestHidden = Integer.MAX_VALUE;
        for (int x = xMin; x <= xMax; ++x) {
            if (Math.abs(x) > Math.max(distanceClosestVisible, distanceClosestHidden)) continue;
            for (int z = zMin; z <= zMax; ++z) {
                if (Math.abs(z) > Math.max(distanceClosestVisible, distanceClosestHidden)) continue;
                for (int y = yMin; y <= yMax; ++y) {
                    boolean isHidden;
                    if (Math.abs(y) > Math.max(distanceClosestVisible, distanceClosestHidden)) continue;
                    mutableBlockPos.func_181079_c(x, y, z);
                    if (!GravePosition.isFreeSpot(worldPositionResult.getWorld(), (BlockPos)mutableBlockPos, true, false)) continue;
                    int distanceCurrent = (int)Math.round(mutableBlockPos.func_177957_d((double)worldPositionResult.blockPos.func_177958_n() + 0.5, (double)worldPositionResult.blockPos.func_177956_o() + 0.5, (double)worldPositionResult.blockPos.func_177952_p() + 0.5));
                    Vec3d vTarget = new Vec3d((double)mutableBlockPos.func_177958_n() + 0.5, (double)mutableBlockPos.func_177956_o() + 0.5, (double)mutableBlockPos.func_177952_p() + 0.5);
                    RayTraceResult rayTraceResult = worldPositionResult.getWorld().func_72933_a(vStarting, vTarget);
                    boolean bl = isHidden = rayTraceResult == null || !rayTraceResult.func_178782_a().equals((Object)mutableBlockPos);
                    if (isHidden) {
                        if (distanceCurrent >= distanceClosestHidden) continue;
                        if (GraveKeeperConfig.DEBUG_LOGS) {
                            GraveKeeper.logger.info(String.format("New hidden free spot is closer: %d -> %d", distanceClosestHidden, distanceCurrent));
                        }
                        distanceClosestHidden = distanceCurrent;
                        blockPosHidden = mutableBlockPos.func_185334_h();
                        continue;
                    }
                    if (distanceCurrent >= distanceClosestVisible) continue;
                    if (GraveKeeperConfig.DEBUG_LOGS) {
                        GraveKeeper.logger.info(String.format("New visible free spot is closer: %d -> %d", distanceClosestVisible, distanceCurrent));
                    }
                    distanceClosestVisible = distanceCurrent;
                    blockPosVisible = mutableBlockPos.func_185334_h();
                }
            }
        }
        if (distanceClosestVisible != Integer.MAX_VALUE) {
            if (GraveKeeperConfig.DEBUG_LOGS) {
                GraveKeeper.logger.info(String.format("Found closest visible block %d m away at (%d %d %d)", distanceClosestVisible, blockPosVisible.func_177958_n(), blockPosVisible.func_177956_o(), blockPosVisible.func_177952_p()));
            }
            worldPositionResult.blockPos = blockPosVisible;
            return true;
        }
        if (distanceClosestHidden != Integer.MAX_VALUE) {
            if (GraveKeeperConfig.DEBUG_LOGS) {
                GraveKeeper.logger.info(String.format("Found closest hidden block %d m away at (%d %d %d)", distanceClosestHidden, blockPosHidden.func_177958_n(), blockPosHidden.func_177956_o(), blockPosHidden.func_177952_p()));
            }
            worldPositionResult.blockPos = blockPosHidden;
            return true;
        }
        return false;
    }

    private static boolean updateVertically(@Nonnull WorldPosition worldPositionResult, boolean isFlying) {
        if (GraveKeeperConfig.DEBUG_LOGS) {
            GraveKeeper.logger.info(String.format("Starting position is %s, searching %s", worldPositionResult.blockPos, isFlying ? "down below" : "up above"));
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(worldPositionResult.blockPos);
        int y = worldPositionResult.blockPos.func_177956_o();
        while (y >= GraveKeeperConfig.SEARCH_MIN_ALTITUDE && y < worldPositionResult.getWorld().func_72800_K() - 1) {
            mutableBlockPos.func_185336_p(y);
            if (GravePosition.isFreeSpot(worldPositionResult.getWorld(), (BlockPos)mutableBlockPos, true, true)) {
                if (GraveKeeperConfig.DEBUG_LOGS) {
                    GraveKeeper.logger.info(String.format("Found vertical block at (%d %d %d)", mutableBlockPos.func_177958_n(), mutableBlockPos.func_177956_o(), mutableBlockPos.func_177952_p()));
                }
                worldPositionResult.blockPos = mutableBlockPos.func_185334_h();
                return true;
            }
            if (isFlying) {
                --y;
                continue;
            }
            ++y;
        }
        return false;
    }

    private static boolean isFreeSpot(@Nonnull World world, @Nonnull BlockPos blockPos, boolean shouldCheckBase, boolean allowLiquidBase) {
        boolean isAirOrReplaceable;
        if (blockPos.func_177956_o() < GraveKeeperConfig.SEARCH_MIN_ALTITUDE || blockPos.func_177956_o() > world.func_72800_K() - 1) {
            assert (false);
            return false;
        }
        IBlockState blockStateDown = world.func_180495_p(blockPos.func_177977_b());
        if (!(!shouldCheckBase || blockStateDown.func_185904_a().func_76220_a() || allowLiquidBase && blockStateDown.func_185904_a().func_76224_d())) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(blockPos);
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        boolean bl = isAirOrReplaceable = blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, blockPos) || blockState.func_177230_c().func_176200_f((IBlockAccess)world, blockPos);
        if (isAirOrReplaceable && GraveKeeperConfig.DEBUG_LOGS) {
            GraveKeeper.logger.info(String.format("Found free spot at (%d %d %d)", blockPos.func_177956_o(), blockPos.func_177956_o(), blockPos.func_177952_p()));
        }
        return isAirOrReplaceable;
    }
}

