/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.core;

import com.quantumlytangled.gravekeeper.GraveKeeper;
import com.quantumlytangled.gravekeeper.GraveKeeperConfig;
import com.quantumlytangled.gravekeeper.compatibility.CompatMain;
import com.quantumlytangled.gravekeeper.compatibility.ICompatInventory;
import com.quantumlytangled.gravekeeper.core.CharmHandler;
import com.quantumlytangled.gravekeeper.util.InventorySlot;
import com.quantumlytangled.gravekeeper.util.InventoryType;
import com.quantumlytangled.gravekeeper.util.SoulboundHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class InventoryHandler {
    private static final LinkedHashMap<InventoryType, ICompatInventory> compatInventories = new LinkedHashMap(10);

    public static void addCompatibilityWrapper(@Nonnull ICompatInventory compatInventory) {
        compatInventories.put(compatInventory.getType(), compatInventory);
    }

    @Nonnull
    public static List<InventorySlot> collectOnDeath(@Nonnull EntityPlayerMP player) {
        ArrayList<InventorySlot> inventorySlots = new ArrayList<InventorySlot>();
        CharmHandler.Mode charmMode = InventoryHandler.computeCharmMode(player);
        if (GraveKeeperConfig.DEBUG_LOGS) {
            GraveKeeper.logger.info(String.format("Charm mode is %s", new Object[]{charmMode}));
        }
        for (ICompatInventory compatInventory : compatInventories.values()) {
            InventoryHandler.collectOnDeath(player, charmMode, inventorySlots, compatInventory);
        }
        if (GraveKeeperConfig.MOVE_SOULBOUND_ITEMS_TO_MAIN_INVENTORY) {
            for (InventorySlot inventorySlot : inventorySlots) {
                if (!inventorySlot.isSoulbound || inventorySlot.type == InventoryType.ARMOUR || inventorySlot.type == InventoryType.MAIN || player.field_71071_by.func_70441_a(inventorySlot.itemStack.func_77946_l())) continue;
                GraveKeeper.logger.warn(String.format("Failed to move soulbinded item to main inventory (is it full?): %s", inventorySlot.itemStack));
                inventorySlot.isSoulbound = false;
            }
        }
        return inventorySlots;
    }

    @Nonnull
    private static CharmHandler.Mode computeCharmMode(@Nonnull EntityPlayerMP player) {
        CharmHandler.Mode charmMode = CharmHandler.Mode.NONE;
        for (ICompatInventory compatInventory : compatInventories.values()) {
            if (compatInventory.getType() != InventoryType.BAUBLES && compatInventory.getType() != InventoryType.MAIN) continue;
            for (ItemStack itemStack : compatInventory.getAllContents(player)) {
                if (itemStack.func_190926_b()) continue;
                charmMode = CharmHandler.updateMode(charmMode, itemStack);
            }
        }
        return charmMode;
    }

    private static void collectOnDeath(@Nonnull EntityPlayerMP player, @Nonnull CharmHandler.Mode charmMode, @Nonnull List<InventorySlot> inventorySlots, @Nonnull ICompatInventory compatInventory) {
        int countSoulboundRemaining = GraveKeeperConfig.KEEP_SOULBOUND_AMOUNT;
        for (InventorySlot inventorySlot : inventorySlots) {
            if (!inventorySlot.isSoulbound) continue;
            --countSoulboundRemaining;
        }
        NonNullList<ItemStack> itemStacks = compatInventory.getAllContents(player);
        for (int index = 0; index < itemStacks.size(); ++index) {
            boolean isSoulbound;
            ItemStack itemStack = (ItemStack)itemStacks.get(index);
            if (itemStack.func_190926_b()) continue;
            boolean isCharmed = CharmHandler.isCharmed(charmMode, player.field_71071_by.field_70461_c, compatInventory.getType(), index, itemStack);
            if (isCharmed && GraveKeeperConfig.DEBUG_LOGS) {
                GraveKeeper.logger.info(String.format("Keeping charmed item %s with NBT %s", itemStack, itemStack.func_77978_p()));
            }
            boolean bl = isSoulbound = !isCharmed && countSoulboundRemaining > 0 && SoulboundHandler.isSoulbound(itemStack);
            if (isSoulbound) {
                --countSoulboundRemaining;
                if (GraveKeeperConfig.DEBUG_LOGS) {
                    GraveKeeper.logger.info(String.format("Keeping soulbound item %s with NBT %s", itemStack, itemStack.func_77978_p()));
                }
            }
            InventorySlot inventorySlot = new InventorySlot(itemStack, index, compatInventory.getType(), isCharmed, isSoulbound);
            inventorySlots.add(inventorySlot);
            if (isCharmed || isSoulbound && (!GraveKeeperConfig.MOVE_SOULBOUND_ITEMS_TO_MAIN_INVENTORY || inventorySlot.type == InventoryType.ARMOUR || inventorySlot.type == InventoryType.MAIN)) continue;
            compatInventory.removeItem(player, index);
        }
    }

    @Nonnull
    public static List<ItemStack> restoreOrOverflow(@Nonnull EntityPlayerMP player, @Nonnull List<InventorySlot> inventorySlots, boolean doRestoreSoulbound) {
        ArrayList<ItemStack> overflow = new ArrayList<ItemStack>();
        for (InventorySlot inventorySlot : inventorySlots) {
            if (!doRestoreSoulbound && (inventorySlot.isCharmed || inventorySlot.isSoulbound)) continue;
            InventoryHandler.restoreOrOverflow(player, inventorySlot, overflow);
        }
        return overflow;
    }

    private static void restoreOrOverflow(@Nonnull EntityPlayerMP player, @Nonnull InventorySlot inventorySlot, @Nonnull List<ItemStack> overflow) {
        ICompatInventory compatInventory = compatInventories.getOrDefault((Object)inventorySlot.type, CompatMain.getInstance());
        ItemStack itemStackLeft = compatInventory.setItemReturnOverflow(player, inventorySlot.slot, inventorySlot.itemStack);
        if (!itemStackLeft.func_190926_b()) {
            overflow.add(itemStackLeft);
        }
    }
}

