/*
 * Decompiled with CFR 0.152.
 */
package com.quantumlytangled.gravekeeper.util;

import com.quantumlytangled.gravekeeper.GraveKeeper;
import com.quantumlytangled.gravekeeper.GraveKeeperConfig;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class WorldPosition {
    private int dimensionId;
    private String worldName;
    private World world;
    public BlockPos blockPos;

    public WorldPosition(@Nonnull World world, @Nonnull BlockPos blockPos) {
        this.dimensionId = -666;
        this.worldName = null;
        this.world = world;
        this.blockPos = blockPos;
    }

    public WorldPosition(int dimensionId, @Nonnull String worldName, @Nonnull BlockPos blockPos) {
        this.dimensionId = dimensionId;
        this.worldName = worldName;
        this.blockPos = blockPos;
    }

    @Nonnull
    public World getWorld() {
        if (this.world == null) {
            this.world = WorldPosition.getOrCreateWorldServer(this.dimensionId);
            if (this.world == null) {
                GraveKeeper.logger.warn(String.format("Failed to load DIM%d (%s), defaulting to the overworld", this.dimensionId, this.worldName));
                this.world = WorldPosition.getOrCreateWorldServer(0);
            }
        }
        return this.world;
    }

    public void setWorld(@Nonnull World world) {
        this.dimensionId = -666;
        this.worldName = null;
        this.world = world;
    }

    public boolean isSameWorld(@Nonnull World world) {
        return this.dimensionId == world.field_73011_w.getDimension();
    }

    @Nonnull
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("dimensionId", this.world.field_73011_w.getDimension());
        tagCompound.func_74778_a("worldName", WorldPosition.format(this.world));
        tagCompound.func_74768_a("x", this.blockPos.func_177958_n());
        tagCompound.func_74768_a("y", this.blockPos.func_177956_o());
        tagCompound.func_74768_a("z", this.blockPos.func_177952_p());
        return tagCompound;
    }

    @Nonnull
    public WorldPosition(@Nonnull NBTTagCompound tagCompound) {
        this.dimensionId = tagCompound.func_74762_e("dimensionId");
        this.worldName = tagCompound.func_74779_i("worldName");
        this.world = null;
        this.blockPos = new BlockPos(tagCompound.func_74762_e("x"), tagCompound.func_74762_e("y"), tagCompound.func_74762_e("z"));
    }

    @Nonnull
    public String format() {
        return new TextComponentTranslation("gravekeeper.chat.world_xyz", new Object[]{this.world == null ? this.worldName : WorldPosition.format(this.world), this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p()}).func_150260_c();
    }

    @Nonnull
    public static String format(World world) {
        String saveFolder;
        if (world == null) {
            return "~NULL~";
        }
        try {
            saveFolder = world.field_73011_w.getSaveFolder();
        }
        catch (Exception exception) {
            exception.printStackTrace(GraveKeeper.printStreamError);
            saveFolder = "<Exception DIM" + world.field_73011_w.getDimension() + ">";
        }
        if (saveFolder == null || saveFolder.isEmpty()) {
            int dimension = world.field_73011_w.getDimension();
            if (dimension != 0) {
                assert (false);
                return String.format("~invalid dimension %d~", dimension);
            }
            String worldName = world.func_72912_H().func_76065_j();
            if (worldName.equals("MpServer")) {
                return "overworld";
            }
            return worldName;
        }
        return saveFolder;
    }

    public static WorldServer getOrCreateWorldServer(int dimensionId) {
        WorldServer worldServer = DimensionManager.getWorld((int)dimensionId);
        if (worldServer == null) {
            try {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                worldServer = server.func_71218_a(dimensionId);
                if (worldServer.field_73011_w.getDimension() != dimensionId) {
                    throw new RuntimeException(String.format("Inconsistent dimension id %d, expecting %d", worldServer.field_73011_w.getDimension(), dimensionId));
                }
            }
            catch (Exception exception) {
                GraveKeeper.logger.error(String.format("%s: Failed to initialize dimension %d", exception.getMessage(), dimensionId));
                if (GraveKeeperConfig.DEBUG_LOGS) {
                    exception.printStackTrace(GraveKeeper.printStreamError);
                }
                worldServer = null;
            }
        }
        return worldServer;
    }
}

