/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractPartHealer;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.ClientProxy;
import ichttt.mods.firstaid.client.HUDHandler;
import ichttt.mods.firstaid.client.gui.FirstaidIngameGui;
import ichttt.mods.firstaid.client.gui.GuiHealthScreen;
import ichttt.mods.firstaid.client.tutorial.GuiTutorial;
import ichttt.mods.firstaid.client.util.EventCalendar;
import ichttt.mods.firstaid.client.util.PlayerModelRenderer;
import ichttt.mods.firstaid.common.AABBAlignedBoundingBox;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.EventHandler;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.apiimpl.RegistryManager;
import ichttt.mods.firstaid.common.config.ConfigEntry;
import ichttt.mods.firstaid.common.config.ExtraConfig;
import ichttt.mods.firstaid.common.items.FirstAidItems;
import ichttt.mods.firstaid.common.util.ArmorUtils;
import ichttt.mods.firstaid.common.util.CommonUtils;
import ichttt.mods.firstaid.common.util.PlayerSizeHelper;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private static int id;

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)FirstAidItems.BANDAGE, (int)0, (ModelResourceLocation)new ModelResourceLocation("firstaid:bandage"));
        ModelLoader.setCustomModelResourceLocation((Item)FirstAidItems.PLASTER, (int)0, (ModelResourceLocation)new ModelResourceLocation("firstaid:plaster"));
        ModelLoader.setCustomModelResourceLocation((Item)FirstAidItems.MORPHINE, (int)0, (ModelResourceLocation)new ModelResourceLocation("firstaid:morphine"));
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || mc.field_71439_g.field_71174_a == null || mc.func_147113_T()) {
            return;
        }
        if (EventCalendar.isGuiFun()) {
            GuiHealthScreen.BED_ITEMSTACK.func_77964_b(id);
            if (mc.field_71441_e != null && mc.field_71441_e.func_72820_D() % 3L == 0L) {
                ++id;
            }
            if (id > 15) {
                id = 0;
            }
            PlayerModelRenderer.tickFun();
        }
        if (!RegistryManager.debuffConfigErrors.isEmpty() && mc.field_71441_e.field_72995_K) {
            mc.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("[FirstAid] FirstAid has detected invalid debuff config entries."), false);
            for (String s : RegistryManager.debuffConfigErrors) {
                mc.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("[FirstAid] " + s), false);
            }
            RegistryManager.debuffConfigErrors.clear();
        }
        if (HUDHandler.INSTANCE.ticker >= 0) {
            --HUDHandler.INSTANCE.ticker;
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        if (ClientProxy.showWounds.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)Objects.requireNonNull(mc.field_71439_g.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null));
            if (!damageModel.hasTutorial) {
                damageModel.hasTutorial = true;
                CapProvider.tutorialDone.add(mc.field_71439_g.func_70005_c_());
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTutorial());
            } else {
                mc.func_147108_a((GuiScreen)new GuiHealthScreen(damageModel));
            }
        }
    }

    @SubscribeEvent
    public static void preRender(RenderGameOverlayEvent.Pre event) {
        FirstAidConfig.Overlay.VanillaHealthbarMode vanillaHealthBarMode;
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.HEALTH && (vanillaHealthBarMode = FirstAidConfig.overlay.vanillaHealthBarMode) != FirstAidConfig.Overlay.VanillaHealthbarMode.NORMAL) {
            event.setCanceled(true);
            if (vanillaHealthBarMode == FirstAidConfig.Overlay.VanillaHealthbarMode.HIGHLIGHT_CRITICAL_PATH && FirstAidConfig.vanillaHealthCalculation == FirstAidConfig.VanillaHealthCalculationMode.AVERAGE_ALL) {
                FirstaidIngameGui.renderHealth(Minecraft.func_71410_x().field_71456_v, event.getResolution().func_78326_a(), event.getResolution().func_78328_b());
            }
        }
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Post event) {
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.ALL || type == RenderGameOverlayEvent.ElementType.TEXT && FirstAidConfig.overlay.overlayMode != FirstAidConfig.Overlay.OverlayMode.OFF && FirstAidConfig.overlay.pos == FirstAidConfig.Overlay.Position.BOTTOM_LEFT) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!mc.field_71439_g.func_70089_S()) {
                return;
            }
            mc.field_71424_I.func_76320_a("FirstAidOverlay");
            HUDHandler.INSTANCE.renderOverlay(event.getResolution(), event.getPartialTicks());
            mc.field_71424_I.func_76319_b();
            mc.field_71424_I.func_76319_b();
        }
    }

    @SubscribeEvent
    public static void onLivingRender(RenderLivingEvent.Post<EntityPlayer> event) {
        RenderManager renderDispatcher;
        EntityLivingBase entity = event.getEntity();
        if (entity instanceof EntityPlayer && (renderDispatcher = Minecraft.func_71410_x().func_175598_ae()).func_178634_b()) {
            GlStateManager.func_179094_E();
            if (entity.func_70093_af()) {
                GlStateManager.func_179137_b((double)0.0, (double)0.125, (double)0.0);
            }
            AxisAlignedBB aabb = entity.func_174813_aQ();
            Collection<AABBAlignedBoundingBox> allBoxes = PlayerSizeHelper.getBoxes((Entity)entity).values();
            float r = 0.25f;
            float g = 1.0f;
            float b = 1.0f;
            for (AABBAlignedBoundingBox box : allBoxes) {
                AxisAlignedBB bbox = box.createAABB(aabb);
                RenderGlobal.func_189697_a((AxisAlignedBB)bbox.func_186662_g(0.02).func_72317_d(-entity.field_70165_t, -entity.field_70163_u, -entity.field_70161_v), (float)r, (float)g, (float)b, (float)1.0f);
                r += 0.25f;
                g += 0.5f;
                b += 0.1f;
                r %= 1.0f;
                g %= 1.0f;
                b %= 1.0f;
            }
            GlStateManager.func_179121_F();
        }
    }

    private static String makeArmorMsg(double value) {
        return TextFormatting.BLUE + I18n.func_135052_a((String)"firstaid.specificarmor", (Object[])new Object[]{FORMAT.format(value)}) + TextFormatting.RESET;
    }

    private static String makeToughnessMsg(double value) {
        return TextFormatting.BLUE + I18n.func_135052_a((String)"firstaid.specifictoughness", (Object[])new Object[]{FORMAT.format(value)}) + TextFormatting.RESET;
    }

    private static <T> void replaceOrAppend(List<T> list, T search, T replace) {
        int index = list.indexOf(search);
        if (FirstAidConfig.overlay.armorTooltipMode == FirstAidConfig.Overlay.TooltipMode.REPLACE && index >= 0) {
            list.set(index, replace);
        } else {
            list.add(replace);
        }
    }

    @SubscribeEvent
    public static void tooltipItems(ItemTooltipEvent event) {
        AbstractPartHealer healer;
        List list;
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item == FirstAidItems.MORPHINE) {
            event.getToolTip().add(I18n.func_135052_a((String)"firstaid.tooltip.morphine", (Object[])new Object[]{"3:30-4:30"}));
            return;
        }
        if (FirstAidConfig.overlay.armorTooltipMode != FirstAidConfig.Overlay.TooltipMode.NONE) {
            String original;
            double totalArmor;
            ISpecialArmor armor;
            boolean set = false;
            if (item instanceof ISpecialArmor) {
                armor = (ISpecialArmor)item;
                EntityPlayer player = event.getEntityPlayer();
                if (player != null) {
                    int displayArmor;
                    int slot = player.field_71071_by.field_70460_b.indexOf((Object)stack);
                    if (slot == -1 && item instanceof ItemArmor) {
                        slot = ((ItemArmor)item).field_77881_a.func_188454_b();
                    }
                    if (slot >= 0 && slot <= 3 && (displayArmor = armor.getArmorDisplay(event.getEntityPlayer(), stack, slot)) != 0) {
                        set = true;
                        totalArmor = ArmorUtils.applyArmorModifier(CommonUtils.ARMOR_SLOTS[slot], displayArmor);
                        original = TextFormatting.BLUE + " " + net.minecraft.util.text.translation.I18n.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{FORMAT.format(displayArmor), net.minecraft.util.text.translation.I18n.func_74838_a((String)"attribute.name.generic.armor")});
                        ClientEventHandler.replaceOrAppend(event.getToolTip(), original, ClientEventHandler.makeArmorMsg(totalArmor));
                    }
                }
            }
            if (item instanceof ItemArmor && !set) {
                double normalToughness;
                double totalToughness;
                armor = (ItemArmor)item;
                List tooltip = event.getToolTip();
                double normalArmor = ArmorUtils.getArmor(stack, armor.func_185083_B_(), false);
                totalArmor = ArmorUtils.applyArmorModifier(armor.field_77881_a, normalArmor);
                if (totalArmor > 0.0) {
                    original = TextFormatting.BLUE + " " + net.minecraft.util.text.translation.I18n.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{FORMAT.format(normalArmor), net.minecraft.util.text.translation.I18n.func_74838_a((String)"attribute.name.generic.armor")});
                    ClientEventHandler.replaceOrAppend(tooltip, original, ClientEventHandler.makeArmorMsg(totalArmor));
                }
                if ((totalToughness = ArmorUtils.applyToughnessModifier(armor.field_77881_a, normalToughness = ArmorUtils.getArmorToughness(stack, armor.func_185083_B_(), false))) > 0.0) {
                    String original2 = TextFormatting.BLUE + " " + net.minecraft.util.text.translation.I18n.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{FORMAT.format(normalToughness), net.minecraft.util.text.translation.I18n.func_74838_a((String)"attribute.name.generic.armorToughness")});
                    ClientEventHandler.replaceOrAppend(tooltip, original2, ClientEventHandler.makeToughnessMsg(totalToughness));
                }
                if (ArmorUtils.QUALITY_TOOLS_PRESENT) {
                    double qualityToolsNormalToughness;
                    double qualityToolsTotalToughness;
                    double qualityToolsNormalArmor = ArmorUtils.getValueFromQualityTools(SharedMonsterAttributes.field_188791_g, stack);
                    double qualityToolsTotalArmor = qualityToolsNormalArmor * ArmorUtils.getArmorMultiplier(armor.field_77881_a);
                    if (qualityToolsTotalArmor > 0.0) {
                        String original3 = TextFormatting.BLUE + " " + net.minecraft.util.text.translation.I18n.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{FORMAT.format(qualityToolsNormalArmor), net.minecraft.util.text.translation.I18n.func_74838_a((String)"attribute.name.generic.armor")});
                        ClientEventHandler.replaceOrAppend(tooltip, original3, ClientEventHandler.makeArmorMsg(qualityToolsTotalArmor));
                    }
                    if ((qualityToolsTotalToughness = (qualityToolsNormalToughness = ArmorUtils.getValueFromQualityTools(SharedMonsterAttributes.field_189429_h, stack)) * ArmorUtils.getToughnessMultiplier(armor.field_77881_a)) > 0.0) {
                        String original4 = TextFormatting.BLUE + " " + net.minecraft.util.text.translation.I18n.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{FORMAT.format(qualityToolsNormalToughness), net.minecraft.util.text.translation.I18n.func_74838_a((String)"attribute.name.generic.armorToughness")});
                        ClientEventHandler.replaceOrAppend(tooltip, original4, ClientEventHandler.makeToughnessMsg(qualityToolsTotalToughness));
                    }
                }
            }
        }
        if (item instanceof ItemPotion && !(list = PotionUtils.func_185189_a((ItemStack)stack)).isEmpty()) {
            for (PotionEffect potionEffect : list) {
                Potion potion;
                Map map;
                if (EventHandler.RESISTANCE == null || potionEffect.func_188419_a() != EventHandler.RESISTANCE || (map = (potion = potionEffect.func_188419_a()).func_111186_k()).isEmpty()) continue;
                for (Map.Entry entry : map.entrySet()) {
                    AttributeModifier falseModifier = (AttributeModifier)entry.getValue();
                    AttributeModifier realModifier = new AttributeModifier(falseModifier.func_111166_b(), potion.func_111183_a(potionEffect.func_76458_c(), falseModifier), falseModifier.func_111169_c());
                    double d1 = realModifier.func_111169_c() != 1 && realModifier.func_111169_c() != 2 ? realModifier.func_111164_d() : realModifier.func_111164_d() * 100.0;
                    String raw = TextFormatting.BLUE + net.minecraft.util.text.translation.I18n.func_74837_a((String)("attribute.modifier.plus." + realModifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), net.minecraft.util.text.translation.I18n.func_74838_a((String)("attribute.name." + ((IAttribute)entry.getKey()).func_111108_a()))});
                    String replacement = TextFormatting.BLUE + net.minecraft.util.text.translation.I18n.func_74837_a((String)("attribute.modifier.plus." + realModifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 * (double)((float)FirstAidConfig.externalHealing.resistanceReductionPercentPerLevel / 20.0f)), net.minecraft.util.text.translation.I18n.func_74838_a((String)("attribute.name." + ((IAttribute)entry.getKey()).func_111108_a()))});
                    List toolTip = event.getToolTip();
                    int index = toolTip.indexOf(raw);
                    if (index == -1) continue;
                    toolTip.set(index, replacement);
                }
            }
        }
        if ((healer = FirstAidRegistryImpl.INSTANCE.getPartHealer(stack)) != null) {
            event.getToolTip().add(I18n.func_135052_a((String)"firstaid.tooltip.healer", (Object[])new Object[]{healer.maxHeal / 2, StringUtils.func_76337_a((int)healer.ticksPerHeal)}));
        }
    }

    @SubscribeEvent
    public static void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        FirstAid.isSynced = false;
        for (ConfigEntry<ExtraConfig.Sync> option : FirstAid.syncedConfigOptions) {
            if (!option.hasRemoteData()) continue;
            option.revert();
        }
        HUDHandler.INSTANCE.ticker = -1;
    }
}

